
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for Pdf417CompactionModeType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="Pdf417CompactionModeType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="text"/>
 *     <enumeration value="numeric"/>
 *     <enumeration value="byte"/>
 *     <enumeration value="auto"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "Pdf417CompactionModeType")
@XmlEnum
public enum Pdf417CompactionModeType {

    @XmlEnumValue("text")
    TEXT("text"),
    @XmlEnumValue("numeric")
    NUMERIC("numeric"),
    @XmlEnumValue("byte")
    BYTE("byte"),
    @XmlEnumValue("auto")
    AUTO("auto");
    private final String value;

    Pdf417CompactionModeType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static Pdf417CompactionModeType fromValue(String v) {
        for (Pdf417CompactionModeType c: Pdf417CompactionModeType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
