
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for PdfaEditProfileType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="PdfaEditProfileType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="generalEditRestrictions"/>
 *     <enumeration value="removePdfaMetadata"/>
 *     <enumeration value="noEditRestrictions"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "PdfaEditProfileType")
@XmlEnum
public enum PdfaEditProfileType {

    @XmlEnumValue("generalEditRestrictions")
    GENERAL_EDIT_RESTRICTIONS("generalEditRestrictions"),
    @XmlEnumValue("removePdfaMetadata")
    REMOVE_PDFA_METADATA("removePdfaMetadata"),
    @XmlEnumValue("noEditRestrictions")
    NO_EDIT_RESTRICTIONS("noEditRestrictions");
    private final String value;

    PdfaEditProfileType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static PdfaEditProfileType fromValue(String v) {
        for (PdfaEditProfileType c: PdfaEditProfileType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
