
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for PrintModeType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="PrintModeType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="default"/>
 *     <enumeration value="raster"/>
 *     <enumeration value="image"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "PrintModeType")
@XmlEnum
public enum PrintModeType {

    @XmlEnumValue("default")
    DEFAULT("default"),
    @XmlEnumValue("raster")
    RASTER("raster"),
    @XmlEnumValue("image")
    IMAGE("image");
    private final String value;

    PrintModeType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static PrintModeType fromValue(String v) {
        for (PrintModeType c: PrintModeType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
