
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The print operation element can be used to print documents.&lt;/p&gt;
 * </pre>
 * 
 * 
 * <p>Java class for PrintType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="PrintType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}BaseToolboxType">
 *       <attribute name="printerName" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="pages" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="jobName" type="{http://www.w3.org/2001/XMLSchema}string" default="webPDF Print Job" />
 *       <attribute name="copies" default="1">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="1"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="autoRotate" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       <attribute name="shrinkToMargins" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="expandToMargins" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="centerInPage" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="dpi" type="{http://www.w3.org/2001/XMLSchema}int" default="0" />
 *       <attribute name="mode" type="{http://schema.webpdf.de/1.0/operation}PrintModeType" default="default" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "PrintType")
public class PrintType
    extends BaseToolboxType
{

    @XmlAttribute(name = "printerName")
    protected String printerName;
    @XmlAttribute(name = "pages")
    protected String pages;
    @XmlAttribute(name = "jobName")
    protected String jobName;
    @XmlAttribute(name = "copies")
    protected Integer copies;
    @XmlAttribute(name = "autoRotate")
    protected Boolean autoRotate;
    @XmlAttribute(name = "shrinkToMargins")
    protected Boolean shrinkToMargins;
    @XmlAttribute(name = "expandToMargins")
    protected Boolean expandToMargins;
    @XmlAttribute(name = "centerInPage")
    protected Boolean centerInPage;
    @XmlAttribute(name = "dpi")
    protected Integer dpi;
    @XmlAttribute(name = "mode")
    protected PrintModeType mode;

    /**
     * Gets the value of the printerName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPrinterName() {
        if (printerName == null) {
            return "";
        } else {
            return printerName;
        }
    }

    /**
     * Sets the value of the printerName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPrinterName(String value) {
        this.printerName = value;
    }

    public boolean isSetPrinterName() {
        return (this.printerName!= null);
    }

    /**
     * Gets the value of the pages property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getPages() {
        if (pages == null) {
            return "";
        } else {
            return pages;
        }
    }

    /**
     * Sets the value of the pages property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setPages(String value) {
        this.pages = value;
    }

    public boolean isSetPages() {
        return (this.pages!= null);
    }

    /**
     * Gets the value of the jobName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getJobName() {
        if (jobName == null) {
            return "webPDF Print Job";
        } else {
            return jobName;
        }
    }

    /**
     * Sets the value of the jobName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setJobName(String value) {
        this.jobName = value;
    }

    public boolean isSetJobName() {
        return (this.jobName!= null);
    }

    /**
     * Gets the value of the copies property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getCopies() {
        if (copies == null) {
            return  1;
        } else {
            return copies;
        }
    }

    /**
     * Sets the value of the copies property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setCopies(int value) {
        this.copies = value;
    }

    public boolean isSetCopies() {
        return (this.copies!= null);
    }

    public void unsetCopies() {
        this.copies = null;
    }

    /**
     * Gets the value of the autoRotate property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isAutoRotate() {
        if (autoRotate == null) {
            return true;
        } else {
            return autoRotate;
        }
    }

    /**
     * Sets the value of the autoRotate property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setAutoRotate(boolean value) {
        this.autoRotate = value;
    }

    public boolean isSetAutoRotate() {
        return (this.autoRotate!= null);
    }

    public void unsetAutoRotate() {
        this.autoRotate = null;
    }

    /**
     * Gets the value of the shrinkToMargins property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isShrinkToMargins() {
        if (shrinkToMargins == null) {
            return false;
        } else {
            return shrinkToMargins;
        }
    }

    /**
     * Sets the value of the shrinkToMargins property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setShrinkToMargins(boolean value) {
        this.shrinkToMargins = value;
    }

    public boolean isSetShrinkToMargins() {
        return (this.shrinkToMargins!= null);
    }

    public void unsetShrinkToMargins() {
        this.shrinkToMargins = null;
    }

    /**
     * Gets the value of the expandToMargins property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isExpandToMargins() {
        if (expandToMargins == null) {
            return false;
        } else {
            return expandToMargins;
        }
    }

    /**
     * Sets the value of the expandToMargins property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setExpandToMargins(boolean value) {
        this.expandToMargins = value;
    }

    public boolean isSetExpandToMargins() {
        return (this.expandToMargins!= null);
    }

    public void unsetExpandToMargins() {
        this.expandToMargins = null;
    }

    /**
     * Gets the value of the centerInPage property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isCenterInPage() {
        if (centerInPage == null) {
            return false;
        } else {
            return centerInPage;
        }
    }

    /**
     * Sets the value of the centerInPage property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setCenterInPage(boolean value) {
        this.centerInPage = value;
    }

    public boolean isSetCenterInPage() {
        return (this.centerInPage!= null);
    }

    public void unsetCenterInPage() {
        this.centerInPage = null;
    }

    /**
     * Gets the value of the dpi property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getDpi() {
        if (dpi == null) {
            return  0;
        } else {
            return dpi;
        }
    }

    /**
     * Sets the value of the dpi property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setDpi(int value) {
        this.dpi = value;
    }

    public boolean isSetDpi() {
        return (this.dpi!= null);
    }

    public void unsetDpi() {
        this.dpi = null;
    }

    /**
     * Gets the value of the mode property.
     * 
     * @return
     *     possible object is
     *     {@link PrintModeType }
     *     
     */
    public PrintModeType getMode() {
        if (mode == null) {
            return PrintModeType.DEFAULT;
        } else {
            return mode;
        }
    }

    /**
     * Sets the value of the mode property.
     * 
     * @param value
     *     allowed object is
     *     {@link PrintModeType }
     *     
     */
    public void setMode(PrintModeType value) {
        this.mode = value;
    }

    public boolean isSetMode() {
        return (this.mode!= null);
    }

}
