
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for QrSwissPaymentFormatType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="QrSwissPaymentFormatType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="codeOnly"/>
 *     <enumeration value="billOnly"/>
 *     <enumeration value="billPortraitSheet"/>
 *     <enumeration value="billExtraSpace"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "QrSwissPaymentFormatType")
@XmlEnum
public enum QrSwissPaymentFormatType {

    @XmlEnumValue("codeOnly")
    CODE_ONLY("codeOnly"),
    @XmlEnumValue("billOnly")
    BILL_ONLY("billOnly"),
    @XmlEnumValue("billPortraitSheet")
    BILL_PORTRAIT_SHEET("billPortraitSheet"),
    @XmlEnumValue("billExtraSpace")
    BILL_EXTRA_SPACE("billExtraSpace");
    private final String value;

    QrSwissPaymentFormatType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static QrSwissPaymentFormatType fromValue(String v) {
        for (QrSwissPaymentFormatType c: QrSwissPaymentFormatType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
