
package net.webpdf.wsclient.schema.operation;

import java.util.ArrayList;
import java.util.List;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p105796_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:p913707_="https://jakarta.ee/xml/ns/jaxb" xmlns:p931759_="http://jaxb2-commons.dev.java.net/basic/simplify" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;An annotation that marks page content for redaction.&lt;/p&gt;
 * </pre>
 * 
 * 
 * <p>Java class for RedactAnnotationType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="RedactAnnotationType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}BaseAnnotationType">
 *       <all>
 *         <element name="position" minOccurs="0">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <choice maxOccurs="unbounded" minOccurs="0">
 *                   <element name="pathElement" type="{http://schema.webpdf.de/1.0/operation}RectangleType"/>
 *                   <element name="quadrilateral" type="{http://schema.webpdf.de/1.0/operation}QuadrilateralType"/>
 *                 </choice>
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *       </all>
 *       <attribute name="interiorColor" type="{http://schema.webpdf.de/1.0/operation}RgbColorType" default="#000000" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "RedactAnnotationType", propOrder = {
    "position"
})
public class RedactAnnotationType
    extends BaseAnnotationType
{

    protected RedactAnnotationType.Position position;
    @XmlAttribute(name = "interiorColor")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    protected String interiorColor;

    /**
     * Gets the value of the position property.
     * 
     * @return
     *     possible object is
     *     {@link RedactAnnotationType.Position }
     *     
     */
    public RedactAnnotationType.Position getPosition() {
        return position;
    }

    /**
     * Sets the value of the position property.
     * 
     * @param value
     *     allowed object is
     *     {@link RedactAnnotationType.Position }
     *     
     */
    public void setPosition(RedactAnnotationType.Position value) {
        this.position = value;
    }

    public boolean isSetPosition() {
        return (this.position!= null);
    }

    /**
     * Gets the value of the interiorColor property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getInteriorColor() {
        if (interiorColor == null) {
            return "#000000";
        } else {
            return interiorColor;
        }
    }

    /**
     * Sets the value of the interiorColor property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setInteriorColor(String value) {
        this.interiorColor = value;
    }

    public boolean isSetInteriorColor() {
        return (this.interiorColor!= null);
    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <choice maxOccurs="unbounded" minOccurs="0">
     *         <element name="pathElement" type="{http://schema.webpdf.de/1.0/operation}RectangleType"/>
     *         <element name="quadrilateral" type="{http://schema.webpdf.de/1.0/operation}QuadrilateralType"/>
     *       </choice>
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "pathElementOrQuadrilateral"
    })
    public static class Position {

        @XmlElements({
            @XmlElement(name = "pathElement", type = RectangleType.class),
            @XmlElement(name = "quadrilateral", type = QuadrilateralType.class)
        })
        protected List<Object> pathElementOrQuadrilateral;

        /**
         * Gets the value of the pathElementOrQuadrilateral property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the Jakarta XML Binding object.
         * This is why there is not a {@code set} method for the pathElementOrQuadrilateral property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getPathElementOrQuadrilateral().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link QuadrilateralType }
         * {@link RectangleType }
         * 
         * 
         * @return
         *     The value of the pathElementOrQuadrilateral property.
         */
        public List<Object> getPathElementOrQuadrilateral() {
            if (pathElementOrQuadrilateral == null) {
                pathElementOrQuadrilateral = new ArrayList<>();
            }
            return this.pathElementOrQuadrilateral;
        }

        public boolean isSetPathElementOrQuadrilateral() {
            return ((this.pathElementOrQuadrilateral!= null)&&(!this.pathElementOrQuadrilateral.isEmpty()));
        }

        public void unsetPathElementOrQuadrilateral() {
            this.pathElementOrQuadrilateral = null;
        }

    }

}
