
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The scale operation element can be used to scale pages in the document. In the following passage, terms such as the "media box", the "bleed box" and similar are used. This assumes, therefore, that you are familiar with the contexts described in the chapter "Display options".&lt;/p&gt;
 * </pre>
 * 
 * 
 * <p>Java class for ScaleType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="ScaleType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}BaseToolboxType">
 *       <choice>
 *         <element name="scalePages" minOccurs="0">
 *           <complexType>
 *             <complexContent>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 <choice>
 *                   <element name="dimensions" type="{http://schema.webpdf.de/1.0/operation}PaddedRectangleType" minOccurs="0"/>
 *                 </choice>
 *                 <attGroup ref="{http://schema.webpdf.de/1.0/operation}AlignmentGroup"/>
 *                 <attribute name="pages" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *                 <attribute name="scaleBoxes" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *                 <attribute name="preserveAspectRatio" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *               </restriction>
 *             </complexContent>
 *           </complexType>
 *         </element>
 *       </choice>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ScaleType", propOrder = {
    "scalePages"
})
public class ScaleType
    extends BaseToolboxType
{

    protected ScaleType.ScalePages scalePages;

    /**
     * Gets the value of the scalePages property.
     * 
     * @return
     *     possible object is
     *     {@link ScaleType.ScalePages }
     *     
     */
    public ScaleType.ScalePages getScalePages() {
        return scalePages;
    }

    /**
     * Sets the value of the scalePages property.
     * 
     * @param value
     *     allowed object is
     *     {@link ScaleType.ScalePages }
     *     
     */
    public void setScalePages(ScaleType.ScalePages value) {
        this.scalePages = value;
    }

    public boolean isSetScalePages() {
        return (this.scalePages!= null);
    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>{@code
     * <complexType>
     *   <complexContent>
     *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       <choice>
     *         <element name="dimensions" type="{http://schema.webpdf.de/1.0/operation}PaddedRectangleType" minOccurs="0"/>
     *       </choice>
     *       <attGroup ref="{http://schema.webpdf.de/1.0/operation}AlignmentGroup"/>
     *       <attribute name="pages" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
     *       <attribute name="scaleBoxes" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
     *       <attribute name="preserveAspectRatio" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
     *     </restriction>
     *   </complexContent>
     * </complexType>
     * }</pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "dimensions"
    })
    public static class ScalePages {

        protected PaddedRectangleType dimensions;
        @XmlAttribute(name = "pages")
        protected String pages;
        @XmlAttribute(name = "scaleBoxes")
        protected Boolean scaleBoxes;
        @XmlAttribute(name = "preserveAspectRatio")
        protected Boolean preserveAspectRatio;
        @XmlAttribute(name = "horizontalAlignment")
        protected String horizontalAlignment;
        @XmlAttribute(name = "verticalAlignment")
        protected String verticalAlignment;

        /**
         * Gets the value of the dimensions property.
         * 
         * @return
         *     possible object is
         *     {@link PaddedRectangleType }
         *     
         */
        public PaddedRectangleType getDimensions() {
            return dimensions;
        }

        /**
         * Sets the value of the dimensions property.
         * 
         * @param value
         *     allowed object is
         *     {@link PaddedRectangleType }
         *     
         */
        public void setDimensions(PaddedRectangleType value) {
            this.dimensions = value;
        }

        public boolean isSetDimensions() {
            return (this.dimensions!= null);
        }

        /**
         * Gets the value of the pages property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getPages() {
            if (pages == null) {
                return "";
            } else {
                return pages;
            }
        }

        /**
         * Sets the value of the pages property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setPages(String value) {
            this.pages = value;
        }

        public boolean isSetPages() {
            return (this.pages!= null);
        }

        /**
         * Gets the value of the scaleBoxes property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isScaleBoxes() {
            if (scaleBoxes == null) {
                return true;
            } else {
                return scaleBoxes;
            }
        }

        /**
         * Sets the value of the scaleBoxes property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setScaleBoxes(boolean value) {
            this.scaleBoxes = value;
        }

        public boolean isSetScaleBoxes() {
            return (this.scaleBoxes!= null);
        }

        public void unsetScaleBoxes() {
            this.scaleBoxes = null;
        }

        /**
         * Gets the value of the preserveAspectRatio property.
         * 
         * @return
         *     possible object is
         *     {@link Boolean }
         *     
         */
        public boolean isPreserveAspectRatio() {
            if (preserveAspectRatio == null) {
                return true;
            } else {
                return preserveAspectRatio;
            }
        }

        /**
         * Sets the value of the preserveAspectRatio property.
         * 
         * @param value
         *     allowed object is
         *     {@link Boolean }
         *     
         */
        public void setPreserveAspectRatio(boolean value) {
            this.preserveAspectRatio = value;
        }

        public boolean isSetPreserveAspectRatio() {
            return (this.preserveAspectRatio!= null);
        }

        public void unsetPreserveAspectRatio() {
            this.preserveAspectRatio = null;
        }

        /**
         * Gets the value of the horizontalAlignment property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getHorizontalAlignment() {
            if (horizontalAlignment == null) {
                return "left";
            } else {
                return horizontalAlignment;
            }
        }

        /**
         * Sets the value of the horizontalAlignment property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setHorizontalAlignment(String value) {
            this.horizontalAlignment = value;
        }

        public boolean isSetHorizontalAlignment() {
            return (this.horizontalAlignment!= null);
        }

        /**
         * Gets the value of the verticalAlignment property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getVerticalAlignment() {
            if (verticalAlignment == null) {
                return "top";
            } else {
                return verticalAlignment;
            }
        }

        /**
         * Sets the value of the verticalAlignment property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setVerticalAlignment(String value) {
            this.verticalAlignment = value;
        }

        public boolean isSetVerticalAlignment() {
            return (this.verticalAlignment!= null);
        }

    }

}
