
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for SignatureEditProfileType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="SignatureEditProfileType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="adobeRestrictions"/>
 *     <enumeration value="generalEditRestrictions"/>
 *     <enumeration value="noEditRestrictions"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "SignatureEditProfileType")
@XmlEnum
public enum SignatureEditProfileType {

    @XmlEnumValue("adobeRestrictions")
    ADOBE_RESTRICTIONS("adobeRestrictions"),
    @XmlEnumValue("generalEditRestrictions")
    GENERAL_EDIT_RESTRICTIONS("generalEditRestrictions"),
    @XmlEnumValue("noEditRestrictions")
    NO_EDIT_RESTRICTIONS("noEditRestrictions");
    private final String value;

    SignatureEditProfileType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static SignatureEditProfileType fromValue(String v) {
        for (SignatureEditProfileType c: SignatureEditProfileType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
