
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p20622_="https://jakarta.ee/xml/ns/jaxb" xmlns:p420076_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The &lt;code&gt;signature&lt;/code&gt; element allows to set settings for automatic signature handling and verification. All web services prioritize checking whether their execution is valid for a given signed document - according to these settings - or would risk invalidation of the existing signatures. (This is also defining profiles, that would allow signature invalidation).&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * 
 * <p>Java class for SignatureSettingsType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="SignatureSettingsType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <attribute name="signatureEditProfile" type="{http://schema.webpdf.de/1.0/operation}SignatureEditProfileType" default="adobeRestrictions" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SignatureSettingsType")
public class SignatureSettingsType {

    @XmlAttribute(name = "signatureEditProfile")
    protected SignatureEditProfileType signatureEditProfile;

    /**
     * Gets the value of the signatureEditProfile property.
     * 
     * @return
     *     possible object is
     *     {@link SignatureEditProfileType }
     *     
     */
    public SignatureEditProfileType getSignatureEditProfile() {
        if (signatureEditProfile == null) {
            return SignatureEditProfileType.ADOBE_RESTRICTIONS;
        } else {
            return signatureEditProfile;
        }
    }

    /**
     * Sets the value of the signatureEditProfile property.
     * 
     * @param value
     *     allowed object is
     *     {@link SignatureEditProfileType }
     *     
     */
    public void setSignatureEditProfile(SignatureEditProfileType value) {
        this.signatureEditProfile = value;
    }

    public boolean isSetSignatureEditProfile() {
        return (this.signatureEditProfile!= null);
    }

}
