
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;When activated, the playSound Element plays the specified audio data.&lt;/p&gt;
 * </pre>
 * 
 * 
 * <p>Java class for SoundActionType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="SoundActionType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}ActionEventType">
 *       <all>
 *         <element name="sound" type="{http://www.w3.org/2001/XMLSchema}base64Binary"/>
 *       </all>
 *       <attribute name="volume" default="100">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="-100"/>
 *             <maxInclusive value="100"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="synchronous" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="repeat" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="mix" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="samplingRate" default="8000">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}float">
 *             <minInclusive value="1"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="soundChannels" default="1">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="1"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="sampleSize" default="8">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="1"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="encoding" type="{http://schema.webpdf.de/1.0/operation}AudioEncodingType" default="Raw" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SoundActionType", propOrder = {
    "sound"
})
public class SoundActionType
    extends ActionEventType
{

    @XmlElement(required = true)
    protected byte[] sound;
    @XmlAttribute(name = "volume")
    protected Integer volume;
    @XmlAttribute(name = "synchronous")
    protected Boolean synchronous;
    @XmlAttribute(name = "repeat")
    protected Boolean repeat;
    @XmlAttribute(name = "mix")
    protected Boolean mix;
    @XmlAttribute(name = "samplingRate")
    protected Float samplingRate;
    @XmlAttribute(name = "soundChannels")
    protected Integer soundChannels;
    @XmlAttribute(name = "sampleSize")
    protected Integer sampleSize;
    @XmlAttribute(name = "encoding")
    protected AudioEncodingType encoding;

    /**
     * Gets the value of the sound property.
     * 
     * @return
     *     possible object is
     *     byte[]
     */
    public byte[] getSound() {
        return sound;
    }

    /**
     * Sets the value of the sound property.
     * 
     * @param value
     *     allowed object is
     *     byte[]
     */
    public void setSound(byte[] value) {
        this.sound = value;
    }

    public boolean isSetSound() {
        return (this.sound!= null);
    }

    /**
     * Gets the value of the volume property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getVolume() {
        if (volume == null) {
            return  100;
        } else {
            return volume;
        }
    }

    /**
     * Sets the value of the volume property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setVolume(int value) {
        this.volume = value;
    }

    public boolean isSetVolume() {
        return (this.volume!= null);
    }

    public void unsetVolume() {
        this.volume = null;
    }

    /**
     * Gets the value of the synchronous property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isSynchronous() {
        if (synchronous == null) {
            return false;
        } else {
            return synchronous;
        }
    }

    /**
     * Sets the value of the synchronous property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setSynchronous(boolean value) {
        this.synchronous = value;
    }

    public boolean isSetSynchronous() {
        return (this.synchronous!= null);
    }

    public void unsetSynchronous() {
        this.synchronous = null;
    }

    /**
     * Gets the value of the repeat property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isRepeat() {
        if (repeat == null) {
            return false;
        } else {
            return repeat;
        }
    }

    /**
     * Sets the value of the repeat property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setRepeat(boolean value) {
        this.repeat = value;
    }

    public boolean isSetRepeat() {
        return (this.repeat!= null);
    }

    public void unsetRepeat() {
        this.repeat = null;
    }

    /**
     * Gets the value of the mix property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isMix() {
        if (mix == null) {
            return false;
        } else {
            return mix;
        }
    }

    /**
     * Sets the value of the mix property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setMix(boolean value) {
        this.mix = value;
    }

    public boolean isSetMix() {
        return (this.mix!= null);
    }

    public void unsetMix() {
        this.mix = null;
    }

    /**
     * Gets the value of the samplingRate property.
     * 
     * @return
     *     possible object is
     *     {@link Float }
     *     
     */
    public float getSamplingRate() {
        if (samplingRate == null) {
            return  8000.0F;
        } else {
            return samplingRate;
        }
    }

    /**
     * Sets the value of the samplingRate property.
     * 
     * @param value
     *     allowed object is
     *     {@link Float }
     *     
     */
    public void setSamplingRate(float value) {
        this.samplingRate = value;
    }

    public boolean isSetSamplingRate() {
        return (this.samplingRate!= null);
    }

    public void unsetSamplingRate() {
        this.samplingRate = null;
    }

    /**
     * Gets the value of the soundChannels property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getSoundChannels() {
        if (soundChannels == null) {
            return  1;
        } else {
            return soundChannels;
        }
    }

    /**
     * Sets the value of the soundChannels property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setSoundChannels(int value) {
        this.soundChannels = value;
    }

    public boolean isSetSoundChannels() {
        return (this.soundChannels!= null);
    }

    public void unsetSoundChannels() {
        this.soundChannels = null;
    }

    /**
     * Gets the value of the sampleSize property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getSampleSize() {
        if (sampleSize == null) {
            return  8;
        } else {
            return sampleSize;
        }
    }

    /**
     * Sets the value of the sampleSize property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setSampleSize(int value) {
        this.sampleSize = value;
    }

    public boolean isSetSampleSize() {
        return (this.sampleSize!= null);
    }

    public void unsetSampleSize() {
        this.sampleSize = null;
    }

    /**
     * Gets the value of the encoding property.
     * 
     * @return
     *     possible object is
     *     {@link AudioEncodingType }
     *     
     */
    public AudioEncodingType getEncoding() {
        if (encoding == null) {
            return AudioEncodingType.RAW;
        } else {
            return encoding;
        }
    }

    /**
     * Sets the value of the encoding property.
     * 
     * @param value
     *     allowed object is
     *     {@link AudioEncodingType }
     *     
     */
    public void setEncoding(AudioEncodingType value) {
        this.encoding = value;
    }

    public boolean isSetEncoding() {
        return (this.encoding!= null);
    }

}
