
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for TextAnnotationIconsType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="TextAnnotationIconsType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="check"/>
 *     <enumeration value="checkmark"/>
 *     <enumeration value="circle"/>
 *     <enumeration value="comment"/>
 *     <enumeration value="cross"/>
 *     <enumeration value="crossHair"/>
 *     <enumeration value="insert"/>
 *     <enumeration value="key"/>
 *     <enumeration value="note"/>
 *     <enumeration value="help"/>
 *     <enumeration value="newParagraph"/>
 *     <enumeration value="paragraph"/>
 *     <enumeration value="rightArrow"/>
 *     <enumeration value="rightPointer"/>
 *     <enumeration value="star"/>
 *     <enumeration value="upArrow"/>
 *     <enumeration value="upLeftArrow"/>
 *     <enumeration value="unnamed"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "TextAnnotationIconsType")
@XmlEnum
public enum TextAnnotationIconsType {

    @XmlEnumValue("check")
    CHECK("check"),
    @XmlEnumValue("checkmark")
    CHECKMARK("checkmark"),
    @XmlEnumValue("circle")
    CIRCLE("circle"),
    @XmlEnumValue("comment")
    COMMENT("comment"),
    @XmlEnumValue("cross")
    CROSS("cross"),
    @XmlEnumValue("crossHair")
    CROSS_HAIR("crossHair"),
    @XmlEnumValue("insert")
    INSERT("insert"),
    @XmlEnumValue("key")
    KEY("key"),
    @XmlEnumValue("note")
    NOTE("note"),
    @XmlEnumValue("help")
    HELP("help"),
    @XmlEnumValue("newParagraph")
    NEW_PARAGRAPH("newParagraph"),
    @XmlEnumValue("paragraph")
    PARAGRAPH("paragraph"),
    @XmlEnumValue("rightArrow")
    RIGHT_ARROW("rightArrow"),
    @XmlEnumValue("rightPointer")
    RIGHT_POINTER("rightPointer"),
    @XmlEnumValue("star")
    STAR("star"),
    @XmlEnumValue("upArrow")
    UP_ARROW("upArrow"),
    @XmlEnumValue("upLeftArrow")
    UP_LEFT_ARROW("upLeftArrow"),
    @XmlEnumValue("unnamed")
    UNNAMED("unnamed");
    private final String value;

    TextAnnotationIconsType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static TextAnnotationIconsType fromValue(String v) {
        for (TextAnnotationIconsType c: TextAnnotationIconsType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
