
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlType;


/**
 * <p>Java class for TextDirectionType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <pre>{@code
 * <simpleType name="TextDirectionType">
 *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     <enumeration value="leftToRight"/>
 *     <enumeration value="rightToLeft"/>
 *   </restriction>
 * </simpleType>
 * }</pre>
 * 
 */
@XmlType(name = "TextDirectionType")
@XmlEnum
public enum TextDirectionType {

    @XmlEnumValue("leftToRight")
    LEFT_TO_RIGHT("leftToRight"),
    @XmlEnumValue("rightToLeft")
    RIGHT_TO_LEFT("rightToLeft");
    private final String value;

    TextDirectionType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static TextDirectionType fromValue(String v) {
        for (TextDirectionType c: TextDirectionType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
