
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The transcribe operation element can be used to convert a PDF document into other document formats. Errors and inaccuracies can always occur during such conversions, so the endpoint allows a report to be generated to detect and evaluate possible transfer errors both in the event of an error and in the event of a success.&lt;/p&gt;
 * </pre>
 * 
 * 
 * <p>Java class for TranscribeType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="TranscribeType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}BaseToolboxType">
 *       <choice>
 *         <element name="html" type="{http://schema.webpdf.de/1.0/operation}HtmlTranscribeType"/>
 *       </choice>
 *       <attribute name="errorReport" type="{http://schema.webpdf.de/1.0/operation}TranscribeErrorReportType" default="none" />
 *       <attribute name="successReport" type="{http://schema.webpdf.de/1.0/operation}TranscribeSuccessReportType" default="none" />
 *       <attribute name="failureLevel" type="{http://schema.webpdf.de/1.0/operation}FailureType" default="error" />
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TranscribeType", propOrder = {
    "html"
})
public class TranscribeType
    extends BaseToolboxType
{

    protected HtmlTranscribeType html;
    @XmlAttribute(name = "errorReport")
    protected TranscribeErrorReportType errorReport;
    @XmlAttribute(name = "successReport")
    protected TranscribeSuccessReportType successReport;
    @XmlAttribute(name = "failureLevel")
    protected FailureType failureLevel;

    /**
     * Gets the value of the html property.
     * 
     * @return
     *     possible object is
     *     {@link HtmlTranscribeType }
     *     
     */
    public HtmlTranscribeType getHtml() {
        return html;
    }

    /**
     * Sets the value of the html property.
     * 
     * @param value
     *     allowed object is
     *     {@link HtmlTranscribeType }
     *     
     */
    public void setHtml(HtmlTranscribeType value) {
        this.html = value;
    }

    public boolean isSetHtml() {
        return (this.html!= null);
    }

    /**
     * Gets the value of the errorReport property.
     * 
     * @return
     *     possible object is
     *     {@link TranscribeErrorReportType }
     *     
     */
    public TranscribeErrorReportType getErrorReport() {
        if (errorReport == null) {
            return TranscribeErrorReportType.NONE;
        } else {
            return errorReport;
        }
    }

    /**
     * Sets the value of the errorReport property.
     * 
     * @param value
     *     allowed object is
     *     {@link TranscribeErrorReportType }
     *     
     */
    public void setErrorReport(TranscribeErrorReportType value) {
        this.errorReport = value;
    }

    public boolean isSetErrorReport() {
        return (this.errorReport!= null);
    }

    /**
     * Gets the value of the successReport property.
     * 
     * @return
     *     possible object is
     *     {@link TranscribeSuccessReportType }
     *     
     */
    public TranscribeSuccessReportType getSuccessReport() {
        if (successReport == null) {
            return TranscribeSuccessReportType.NONE;
        } else {
            return successReport;
        }
    }

    /**
     * Sets the value of the successReport property.
     * 
     * @param value
     *     allowed object is
     *     {@link TranscribeSuccessReportType }
     *     
     */
    public void setSuccessReport(TranscribeSuccessReportType value) {
        this.successReport = value;
    }

    public boolean isSetSuccessReport() {
        return (this.successReport!= null);
    }

    /**
     * Gets the value of the failureLevel property.
     * 
     * @return
     *     possible object is
     *     {@link FailureType }
     *     
     */
    public FailureType getFailureLevel() {
        if (failureLevel == null) {
            return FailureType.ERROR;
        } else {
            return failureLevel;
        }
    }

    /**
     * Sets the value of the failureLevel property.
     * 
     * @param value
     *     allowed object is
     *     {@link FailureType }
     *     
     */
    public void setFailureLevel(FailureType value) {
        this.failureLevel = value;
    }

    public boolean isSetFailureLevel() {
        return (this.failureLevel!= null);
    }

}
