
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;The setTransition action shows the changes that result from the actions with the use of the defined transition animation.&lt;/p&gt;
 * </pre>
 * 
 * 
 * <p>Java class for TransitionActionType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="TransitionActionType">
 *   <complexContent>
 *     <extension base="{http://schema.webpdf.de/1.0/operation}ActionEventType">
 *       <attribute name="scaling" default="100">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="effectDimensionHorizontal" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       <attribute name="motionInward" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       <attribute name="flyAreaOpaque" type="{http://www.w3.org/2001/XMLSchema}boolean" default="false" />
 *       <attribute name="flyScale" default="100">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *             <minInclusive value="0"/>
 *             <maxInclusive value="6400"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="direction" type="{http://schema.webpdf.de/1.0/operation}OutlineTransitionDirectionType" default="leftToRight" />
 *       <attribute name="style" type="{http://schema.webpdf.de/1.0/operation}OutlineTransitionStyleType" default="none" />
 *       <attribute name="duration" default="1">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}float">
 *             <minInclusive value="0"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TransitionActionType")
public class TransitionActionType
    extends ActionEventType
{

    @XmlAttribute(name = "scaling")
    protected Integer scaling;
    @XmlAttribute(name = "effectDimensionHorizontal")
    protected Boolean effectDimensionHorizontal;
    @XmlAttribute(name = "motionInward")
    protected Boolean motionInward;
    @XmlAttribute(name = "flyAreaOpaque")
    protected Boolean flyAreaOpaque;
    @XmlAttribute(name = "flyScale")
    protected Integer flyScale;
    @XmlAttribute(name = "direction")
    protected OutlineTransitionDirectionType direction;
    @XmlAttribute(name = "style")
    protected OutlineTransitionStyleType style;
    @XmlAttribute(name = "duration")
    protected Float duration;

    /**
     * Gets the value of the scaling property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getScaling() {
        if (scaling == null) {
            return  100;
        } else {
            return scaling;
        }
    }

    /**
     * Sets the value of the scaling property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setScaling(int value) {
        this.scaling = value;
    }

    public boolean isSetScaling() {
        return (this.scaling!= null);
    }

    public void unsetScaling() {
        this.scaling = null;
    }

    /**
     * Gets the value of the effectDimensionHorizontal property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isEffectDimensionHorizontal() {
        if (effectDimensionHorizontal == null) {
            return true;
        } else {
            return effectDimensionHorizontal;
        }
    }

    /**
     * Sets the value of the effectDimensionHorizontal property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setEffectDimensionHorizontal(boolean value) {
        this.effectDimensionHorizontal = value;
    }

    public boolean isSetEffectDimensionHorizontal() {
        return (this.effectDimensionHorizontal!= null);
    }

    public void unsetEffectDimensionHorizontal() {
        this.effectDimensionHorizontal = null;
    }

    /**
     * Gets the value of the motionInward property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isMotionInward() {
        if (motionInward == null) {
            return true;
        } else {
            return motionInward;
        }
    }

    /**
     * Sets the value of the motionInward property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setMotionInward(boolean value) {
        this.motionInward = value;
    }

    public boolean isSetMotionInward() {
        return (this.motionInward!= null);
    }

    public void unsetMotionInward() {
        this.motionInward = null;
    }

    /**
     * Gets the value of the flyAreaOpaque property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public boolean isFlyAreaOpaque() {
        if (flyAreaOpaque == null) {
            return false;
        } else {
            return flyAreaOpaque;
        }
    }

    /**
     * Sets the value of the flyAreaOpaque property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setFlyAreaOpaque(boolean value) {
        this.flyAreaOpaque = value;
    }

    public boolean isSetFlyAreaOpaque() {
        return (this.flyAreaOpaque!= null);
    }

    public void unsetFlyAreaOpaque() {
        this.flyAreaOpaque = null;
    }

    /**
     * Gets the value of the flyScale property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public int getFlyScale() {
        if (flyScale == null) {
            return  100;
        } else {
            return flyScale;
        }
    }

    /**
     * Sets the value of the flyScale property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setFlyScale(int value) {
        this.flyScale = value;
    }

    public boolean isSetFlyScale() {
        return (this.flyScale!= null);
    }

    public void unsetFlyScale() {
        this.flyScale = null;
    }

    /**
     * Gets the value of the direction property.
     * 
     * @return
     *     possible object is
     *     {@link OutlineTransitionDirectionType }
     *     
     */
    public OutlineTransitionDirectionType getDirection() {
        if (direction == null) {
            return OutlineTransitionDirectionType.LEFT_TO_RIGHT;
        } else {
            return direction;
        }
    }

    /**
     * Sets the value of the direction property.
     * 
     * @param value
     *     allowed object is
     *     {@link OutlineTransitionDirectionType }
     *     
     */
    public void setDirection(OutlineTransitionDirectionType value) {
        this.direction = value;
    }

    public boolean isSetDirection() {
        return (this.direction!= null);
    }

    /**
     * Gets the value of the style property.
     * 
     * @return
     *     possible object is
     *     {@link OutlineTransitionStyleType }
     *     
     */
    public OutlineTransitionStyleType getStyle() {
        if (style == null) {
            return OutlineTransitionStyleType.NONE;
        } else {
            return style;
        }
    }

    /**
     * Sets the value of the style property.
     * 
     * @param value
     *     allowed object is
     *     {@link OutlineTransitionStyleType }
     *     
     */
    public void setStyle(OutlineTransitionStyleType value) {
        this.style = value;
    }

    public boolean isSetStyle() {
        return (this.style!= null);
    }

    /**
     * Gets the value of the duration property.
     * 
     * @return
     *     possible object is
     *     {@link Float }
     *     
     */
    public float getDuration() {
        if (duration == null) {
            return  1.0F;
        } else {
            return duration;
        }
    }

    /**
     * Sets the value of the duration property.
     * 
     * @param value
     *     allowed object is
     *     {@link Float }
     *     
     */
    public void setDuration(float value) {
        this.duration = value;
    }

    public boolean isSetDuration() {
        return (this.duration!= null);
    }

    public void unsetDuration() {
        this.duration = null;
    }

}
