
package net.webpdf.wsclient.schema.operation;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import net.webpdf.wsclient.schema.FileDataType;


/**
 * 
 * <pre>
 * &lt;?xml version="1.0" encoding="UTF-8"?&gt;&lt;p xmlns:p383362_="https://jakarta.ee/xml/ns/jaxb" xmlns:p837822_="http://jaxb2-commons.dev.java.net/basic/inheritance" xmlns:tns="http://schema.webpdf.de/1.0/operation" xmlns:xs="http://www.w3.org/2001/XMLSchema"&gt;This element defines a file necessary for the transformation, which is passed "Base64 encoded". This element can be used with &lt;code&gt;&amp;lt;resources&amp;gt;&lt;/code&gt; or &lt;code&gt;&amp;lt;visualization&amp;gt;&lt;/code&gt;.&#13;
 *                     In the case of &lt;code&gt;&amp;lt;resources&amp;gt;&lt;/code&gt;, this is a file that defines, for example, an XLST stylesheet or a CSS resource. In the case of an X invoice and the parent &lt;code&gt;&amp;lt;visualization&amp;gt;&lt;/code&gt; it defines a file (XLST stylesheet) which defines a different layout for the PDF output.&#13;
 *                 &lt;/p&gt;
 * </pre>
 * 
 * 
 * <p>Java class for XslTransformationFileType complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="XslTransformationFileType">
 *   <simpleContent>
 *     <extension base="<http://www.w3.org/2001/XMLSchema>base64Binary">
 *       <attGroup ref="{http://schema.webpdf.de/1.0/operation}FileDataGroup"/>
 *       <attribute name="fileName" type="{http://www.w3.org/2001/XMLSchema}string" default="" />
 *       <attribute name="format" default="xslt">
 *         <simpleType>
 *           <restriction base="{http://schema.webpdf.de/1.0/operation}XslTransformationFileFormatType">
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *     </extension>
 *   </simpleContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "XslTransformationFileType", propOrder = {
    "value"
})
public class XslTransformationFileType
    implements FileDataType<byte[]>
{

    @XmlValue
    protected byte[] value;
    @XmlAttribute(name = "fileName")
    protected String fileName;
    @XmlAttribute(name = "format")
    protected XslTransformationFileFormatType format;
    @XmlAttribute(name = "source")
    protected FileDataSourceType source;
    @XmlAttribute(name = "uri")
    @XmlSchemaType(name = "anyURI")
    protected String uri;

    /**
     * Gets the value of the value property.
     * 
     * @return
     *     possible object is
     *     byte[]
     */
    public byte[] getValue() {
        return value;
    }

    /**
     * Sets the value of the value property.
     * 
     * @param value
     *     allowed object is
     *     byte[]
     */
    public void setValue(byte[] value) {
        this.value = value;
    }

    public boolean isSetValue() {
        return (this.value!= null);
    }

    /**
     * Gets the value of the fileName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getFileName() {
        if (fileName == null) {
            return "";
        } else {
            return fileName;
        }
    }

    /**
     * Sets the value of the fileName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setFileName(String value) {
        this.fileName = value;
    }

    public boolean isSetFileName() {
        return (this.fileName!= null);
    }

    /**
     * Gets the value of the format property.
     * 
     * @return
     *     possible object is
     *     {@link XslTransformationFileFormatType }
     *     
     */
    public XslTransformationFileFormatType getFormat() {
        if (format == null) {
            return XslTransformationFileFormatType.XSLT;
        } else {
            return format;
        }
    }

    /**
     * Sets the value of the format property.
     * 
     * @param value
     *     allowed object is
     *     {@link XslTransformationFileFormatType }
     *     
     */
    public void setFormat(XslTransformationFileFormatType value) {
        this.format = value;
    }

    public boolean isSetFormat() {
        return (this.format!= null);
    }

    /**
     * Gets the value of the source property.
     * 
     * @return
     *     possible object is
     *     {@link FileDataSourceType }
     *     
     */
    public FileDataSourceType getSource() {
        if (source == null) {
            return FileDataSourceType.VALUE;
        } else {
            return source;
        }
    }

    /**
     * Sets the value of the source property.
     * 
     * @param value
     *     allowed object is
     *     {@link FileDataSourceType }
     *     
     */
    public void setSource(FileDataSourceType value) {
        this.source = value;
    }

    public boolean isSetSource() {
        return (this.source!= null);
    }

    /**
     * Gets the value of the uri property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getUri() {
        if (uri == null) {
            return "";
        } else {
            return uri;
        }
    }

    /**
     * Sets the value of the uri property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setUri(String value) {
        this.uri = value;
    }

    public boolean isSetUri() {
        return (this.uri!= null);
    }

}
