/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines a single command line switch for the Chromium process. This switch consists of a name for the switch and an associated value.")
@JsonPropertyOrder(value={"mode", "name", "value"})
@JsonTypeName(value="ApplicationConfig_ChromiumBridgeCommandLineSwitch")
public class ApplicationConfigChromiumBridgeCommandLineSwitch {
    public static final String JSON_PROPERTY_MODE = "mode";
    private ModeEnum mode = ModeEnum.ADD;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name = "";
    public static final String JSON_PROPERTY_VALUE = "value";
    private String value = "";

    public ApplicationConfigChromiumBridgeCommandLineSwitch mode(ModeEnum mode) {
        this.mode = mode;
        return this;
    }

    @Schema(name="Defines the operation mode for the command line switch.  *   ADD = add the command line switch *   REMOVE = remove the command line switch")
    @JsonProperty(value="mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public ModeEnum getMode() {
        return this.mode;
    }

    @JsonProperty(value="mode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMode(ModeEnum mode) {
        this.mode = mode;
    }

    public ApplicationConfigChromiumBridgeCommandLineSwitch name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="Sets the name of the Chromium command line switch. The name must be spelled correctly (without \"--\" and in correct upper/lower case), because it will be used unchanged.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public ApplicationConfigChromiumBridgeCommandLineSwitch value(String value) {
        this.value = value;
        return this;
    }

    @Schema(name="Defines the value of the Chromium command line switch. The value for the switch is used unchanged and must be escaped properly.")
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationConfigChromiumBridgeCommandLineSwitch applicationConfigChromiumBridgeCommandLineSwitch = (ApplicationConfigChromiumBridgeCommandLineSwitch)o;
        return Objects.equals((Object)this.mode, (Object)applicationConfigChromiumBridgeCommandLineSwitch.mode) && Objects.equals(this.name, applicationConfigChromiumBridgeCommandLineSwitch.name) && Objects.equals(this.value, applicationConfigChromiumBridgeCommandLineSwitch.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mode, this.name, this.value});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationConfigChromiumBridgeCommandLineSwitch {\n");
        sb.append("    mode: ").append(this.toIndentedString((Object)this.mode)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ModeEnum {
        ADD("add"),
        REMOVE("remove");

        private String value;

        private ModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ModeEnum fromValue(String value) {
            for (ModeEnum b : ModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

