/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.ApplicationConfigOfficeBridgeApp;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines the settings for the MS Office Bridge. The Office Bridge can be used as an alternative (to the built-in conversion) for converting Office documents. The Office Bridge requires a local installation of MS Office on the server and works only on Windows.")
@JsonPropertyOrder(value={"enabled", "excel", "powerPoint", "showMessagesOnDebugView", "useExcel", "usePowerPoint", "useVisio", "useWord", "visio", "word"})
@JsonTypeName(value="ApplicationConfig_OfficeBridge")
public class ApplicationConfigOfficeBridge {
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled = false;
    public static final String JSON_PROPERTY_EXCEL = "excel";
    private ApplicationConfigOfficeBridgeApp excel;
    public static final String JSON_PROPERTY_POWER_POINT = "powerPoint";
    private ApplicationConfigOfficeBridgeApp powerPoint;
    public static final String JSON_PROPERTY_SHOW_MESSAGES_ON_DEBUG_VIEW = "showMessagesOnDebugView";
    private Boolean showMessagesOnDebugView = false;
    public static final String JSON_PROPERTY_USE_EXCEL = "useExcel";
    private Boolean useExcel = true;
    public static final String JSON_PROPERTY_USE_POWER_POINT = "usePowerPoint";
    private Boolean usePowerPoint = true;
    public static final String JSON_PROPERTY_USE_VISIO = "useVisio";
    private Boolean useVisio = false;
    public static final String JSON_PROPERTY_USE_WORD = "useWord";
    private Boolean useWord = true;
    public static final String JSON_PROPERTY_VISIO = "visio";
    private ApplicationConfigOfficeBridgeApp visio;
    public static final String JSON_PROPERTY_WORD = "word";
    private ApplicationConfigOfficeBridgeApp word;

    public ApplicationConfigOfficeBridge enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Schema(name="If enabled, then the MS Office bridge is activated.")
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public ApplicationConfigOfficeBridge excel(ApplicationConfigOfficeBridgeApp excel) {
        this.excel = excel;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="excel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public ApplicationConfigOfficeBridgeApp getExcel() {
        return this.excel;
    }

    @JsonProperty(value="excel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExcel(ApplicationConfigOfficeBridgeApp excel) {
        this.excel = excel;
    }

    public ApplicationConfigOfficeBridge powerPoint(ApplicationConfigOfficeBridgeApp powerPoint) {
        this.powerPoint = powerPoint;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="powerPoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public ApplicationConfigOfficeBridgeApp getPowerPoint() {
        return this.powerPoint;
    }

    @JsonProperty(value="powerPoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPowerPoint(ApplicationConfigOfficeBridgeApp powerPoint) {
        this.powerPoint = powerPoint;
    }

    public ApplicationConfigOfficeBridge showMessagesOnDebugView(Boolean showMessagesOnDebugView) {
        this.showMessagesOnDebugView = showMessagesOnDebugView;
        return this;
    }

    @Schema(name="If enabled, then all debug messages of the Office Bridge will be visible in the Windows application [\"SysInternals DebugView\"](https://docs.microsoft.com/en-us/sysinternals/downloads/debugview)")
    @JsonProperty(value="showMessagesOnDebugView")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getShowMessagesOnDebugView() {
        return this.showMessagesOnDebugView;
    }

    @JsonProperty(value="showMessagesOnDebugView")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShowMessagesOnDebugView(Boolean showMessagesOnDebugView) {
        this.showMessagesOnDebugView = showMessagesOnDebugView;
    }

    public ApplicationConfigOfficeBridge useExcel(Boolean useExcel) {
        this.useExcel = useExcel;
        return this;
    }

    @Schema(name="If enabled, then MS Excel is usable via the Office bridge.")
    @JsonProperty(value="useExcel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getUseExcel() {
        return this.useExcel;
    }

    @JsonProperty(value="useExcel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUseExcel(Boolean useExcel) {
        this.useExcel = useExcel;
    }

    public ApplicationConfigOfficeBridge usePowerPoint(Boolean usePowerPoint) {
        this.usePowerPoint = usePowerPoint;
        return this;
    }

    @Schema(name="If enabled, then MS PowerPoint is usable via the Office bridge.")
    @JsonProperty(value="usePowerPoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getUsePowerPoint() {
        return this.usePowerPoint;
    }

    @JsonProperty(value="usePowerPoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUsePowerPoint(Boolean usePowerPoint) {
        this.usePowerPoint = usePowerPoint;
    }

    public ApplicationConfigOfficeBridge useVisio(Boolean useVisio) {
        this.useVisio = useVisio;
        return this;
    }

    @Schema(name="If enabled, then MS Visio is usable via the Office bridge.")
    @JsonProperty(value="useVisio")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getUseVisio() {
        return this.useVisio;
    }

    @JsonProperty(value="useVisio")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUseVisio(Boolean useVisio) {
        this.useVisio = useVisio;
    }

    public ApplicationConfigOfficeBridge useWord(Boolean useWord) {
        this.useWord = useWord;
        return this;
    }

    @Schema(name="If enabled, then MS Word is usable via the Office bridge.")
    @JsonProperty(value="useWord")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getUseWord() {
        return this.useWord;
    }

    @JsonProperty(value="useWord")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUseWord(Boolean useWord) {
        this.useWord = useWord;
    }

    public ApplicationConfigOfficeBridge visio(ApplicationConfigOfficeBridgeApp visio) {
        this.visio = visio;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="visio")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public ApplicationConfigOfficeBridgeApp getVisio() {
        return this.visio;
    }

    @JsonProperty(value="visio")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVisio(ApplicationConfigOfficeBridgeApp visio) {
        this.visio = visio;
    }

    public ApplicationConfigOfficeBridge word(ApplicationConfigOfficeBridgeApp word) {
        this.word = word;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="word")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public ApplicationConfigOfficeBridgeApp getWord() {
        return this.word;
    }

    @JsonProperty(value="word")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWord(ApplicationConfigOfficeBridgeApp word) {
        this.word = word;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationConfigOfficeBridge applicationConfigOfficeBridge = (ApplicationConfigOfficeBridge)o;
        return Objects.equals(this.enabled, applicationConfigOfficeBridge.enabled) && Objects.equals(this.excel, applicationConfigOfficeBridge.excel) && Objects.equals(this.powerPoint, applicationConfigOfficeBridge.powerPoint) && Objects.equals(this.showMessagesOnDebugView, applicationConfigOfficeBridge.showMessagesOnDebugView) && Objects.equals(this.useExcel, applicationConfigOfficeBridge.useExcel) && Objects.equals(this.usePowerPoint, applicationConfigOfficeBridge.usePowerPoint) && Objects.equals(this.useVisio, applicationConfigOfficeBridge.useVisio) && Objects.equals(this.useWord, applicationConfigOfficeBridge.useWord) && Objects.equals(this.visio, applicationConfigOfficeBridge.visio) && Objects.equals(this.word, applicationConfigOfficeBridge.word);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.excel, this.powerPoint, this.showMessagesOnDebugView, this.useExcel, this.usePowerPoint, this.useVisio, this.useWord, this.visio, this.word);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationConfigOfficeBridge {\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    excel: ").append(this.toIndentedString(this.excel)).append("\n");
        sb.append("    powerPoint: ").append(this.toIndentedString(this.powerPoint)).append("\n");
        sb.append("    showMessagesOnDebugView: ").append(this.toIndentedString(this.showMessagesOnDebugView)).append("\n");
        sb.append("    useExcel: ").append(this.toIndentedString(this.useExcel)).append("\n");
        sb.append("    usePowerPoint: ").append(this.toIndentedString(this.usePowerPoint)).append("\n");
        sb.append("    useVisio: ").append(this.toIndentedString(this.useVisio)).append("\n");
        sb.append("    useWord: ").append(this.toIndentedString(this.useWord)).append("\n");
        sb.append("    visio: ").append(this.toIndentedString(this.visio)).append("\n");
        sb.append("    word: ").append(this.toIndentedString(this.word)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

