/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines settings specific for the MS Visio application in the office bridge.")
@JsonPropertyOrder(value={"minExecutionTime", "oleStartWaitTime", "oleTerminationTimeout", "useExecutionTest"})
@JsonTypeName(value="ApplicationConfig_OfficeBridgeApp")
public class ApplicationConfigOfficeBridgeApp {
    public static final String JSON_PROPERTY_MIN_EXECUTION_TIME = "minExecutionTime";
    private Integer minExecutionTime = 5000;
    public static final String JSON_PROPERTY_OLE_START_WAIT_TIME = "oleStartWaitTime";
    private Integer oleStartWaitTime = 0;
    public static final String JSON_PROPERTY_OLE_TERMINATION_TIMEOUT = "oleTerminationTimeout";
    private Integer oleTerminationTimeout = 0;
    public static final String JSON_PROPERTY_USE_EXECUTION_TEST = "useExecutionTest";
    private Boolean useExecutionTest = true;

    public ApplicationConfigOfficeBridgeApp minExecutionTime(Integer minExecutionTime) {
        this.minExecutionTime = minExecutionTime;
        return this;
    }

    @Schema(name="The minimum time frame provided for the execution of an operation with the Office bridge.")
    @JsonProperty(value="minExecutionTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getMinExecutionTime() {
        return this.minExecutionTime;
    }

    @JsonProperty(value="minExecutionTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMinExecutionTime(Integer minExecutionTime) {
        this.minExecutionTime = minExecutionTime;
    }

    public ApplicationConfigOfficeBridgeApp oleStartWaitTime(Integer oleStartWaitTime) {
        this.oleStartWaitTime = oleStartWaitTime;
        return this;
    }

    @Schema(name="The time in seconds to wait for the OLE server to start during initialization.")
    @JsonProperty(value="oleStartWaitTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getOleStartWaitTime() {
        return this.oleStartWaitTime;
    }

    @JsonProperty(value="oleStartWaitTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOleStartWaitTime(Integer oleStartWaitTime) {
        this.oleStartWaitTime = oleStartWaitTime;
    }

    public ApplicationConfigOfficeBridgeApp oleTerminationTimeout(Integer oleTerminationTimeout) {
        this.oleTerminationTimeout = oleTerminationTimeout;
        return this;
    }

    @Schema(name="The time in seconds to wait for the OLE server to terminate at shutdown.")
    @JsonProperty(value="oleTerminationTimeout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getOleTerminationTimeout() {
        return this.oleTerminationTimeout;
    }

    @JsonProperty(value="oleTerminationTimeout")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOleTerminationTimeout(Integer oleTerminationTimeout) {
        this.oleTerminationTimeout = oleTerminationTimeout;
    }

    public ApplicationConfigOfficeBridgeApp useExecutionTest(Boolean useExecutionTest) {
        this.useExecutionTest = useExecutionTest;
        return this;
    }

    @Schema(name="If this option is enabled, the Office Bridge application is started in test mode when the server is initialized, which provides advanced debugging information.")
    @JsonProperty(value="useExecutionTest")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getUseExecutionTest() {
        return this.useExecutionTest;
    }

    @JsonProperty(value="useExecutionTest")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUseExecutionTest(Boolean useExecutionTest) {
        this.useExecutionTest = useExecutionTest;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationConfigOfficeBridgeApp applicationConfigOfficeBridgeApp = (ApplicationConfigOfficeBridgeApp)o;
        return Objects.equals(this.minExecutionTime, applicationConfigOfficeBridgeApp.minExecutionTime) && Objects.equals(this.oleStartWaitTime, applicationConfigOfficeBridgeApp.oleStartWaitTime) && Objects.equals(this.oleTerminationTimeout, applicationConfigOfficeBridgeApp.oleTerminationTimeout) && Objects.equals(this.useExecutionTest, applicationConfigOfficeBridgeApp.useExecutionTest);
    }

    public int hashCode() {
        return Objects.hash(this.minExecutionTime, this.oleStartWaitTime, this.oleTerminationTimeout, this.useExecutionTest);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationConfigOfficeBridgeApp {\n");
        sb.append("    minExecutionTime: ").append(this.toIndentedString(this.minExecutionTime)).append("\n");
        sb.append("    oleStartWaitTime: ").append(this.toIndentedString(this.oleStartWaitTime)).append("\n");
        sb.append("    oleTerminationTimeout: ").append(this.toIndentedString(this.oleTerminationTimeout)).append("\n");
        sb.append("    useExecutionTest: ").append(this.toIndentedString(this.useExecutionTest)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

