/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines the settings for the MS SharePoint Bridge. The SharePoint Bridge can be used as an alternative (to the built-in conversion) for converting Office documents. The SharePoint Bridge requires an external installed and configured SharePoint Server.")
@JsonPropertyOrder(value={"enabled", "password", "url", "username"})
@JsonTypeName(value="ApplicationConfig_SharePointBridge")
public class ApplicationConfigSharePointBridge {
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled = false;
    public static final String JSON_PROPERTY_PASSWORD = "password";
    private String password = "";
    public static final String JSON_PROPERTY_URL = "url";
    private String url = "";
    public static final String JSON_PROPERTY_USERNAME = "username";
    private String username = "";

    public ApplicationConfigSharePointBridge enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Schema(name="When set to true the MS SharePoint bridge shall be enabled.")
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public ApplicationConfigSharePointBridge password(String password) {
        this.password = password;
        return this;
    }

    @Schema(name="The password used to authenticate at the MS SharePoint converter.")
    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPassword(String password) {
        this.password = password;
    }

    public ApplicationConfigSharePointBridge url(String url) {
        this.url = url;
        return this;
    }

    @Schema(name="Sets the URL where the MS SharePoint converter can be contacted.")
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUrl(String url) {
        this.url = url;
    }

    public ApplicationConfigSharePointBridge username(String username) {
        this.username = username;
        return this;
    }

    @Schema(name="The username used to authenticate at the MS SharePoint converter.")
    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getUsername() {
        return this.username;
    }

    @JsonProperty(value="username")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUsername(String username) {
        this.username = username;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationConfigSharePointBridge applicationConfigSharePointBridge = (ApplicationConfigSharePointBridge)o;
        return Objects.equals(this.enabled, applicationConfigSharePointBridge.enabled) && Objects.equals(this.password, applicationConfigSharePointBridge.password) && Objects.equals(this.url, applicationConfigSharePointBridge.url) && Objects.equals(this.username, applicationConfigSharePointBridge.username);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.password, this.url, this.username);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApplicationConfigSharePointBridge {\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

