/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.webpdf.wsclient.openapi.CertificateEntry;
import net.webpdf.wsclient.openapi.KeyStoreEntry;
import org.jetbrains.annotations.NotNull;

@Schema(description="Contains the list of certificates and keystores available for the user in the current session.")
@JsonPropertyOrder(value={"certificates", "keyStores"})
@JsonTypeName(value="Auth_UserCertificates")
public class AuthUserCertificates {
    public static final String JSON_PROPERTY_CERTIFICATES = "certificates";
    private List<CertificateEntry> certificates = new ArrayList<CertificateEntry>();
    public static final String JSON_PROPERTY_KEY_STORES = "keyStores";
    private List<KeyStoreEntry> keyStores = new ArrayList<KeyStoreEntry>();

    public AuthUserCertificates() {
    }

    @JsonCreator
    public AuthUserCertificates(@JsonProperty(value="certificates") List<CertificateEntry> certificates, @JsonProperty(value="keyStores") List<KeyStoreEntry> keyStores) {
        this();
        this.certificates = certificates;
        this.keyStores = keyStores;
    }

    @Schema(required=true, name="List of certificates")
    @JsonProperty(value="certificates")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public List<CertificateEntry> getCertificates() {
        return this.certificates;
    }

    @Schema(required=true, name="List of keystores")
    @JsonProperty(value="keyStores")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public List<KeyStoreEntry> getKeyStores() {
        return this.keyStores;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthUserCertificates authUserCertificates = (AuthUserCertificates)o;
        return Objects.equals(this.certificates, authUserCertificates.certificates) && Objects.equals(this.keyStores, authUserCertificates.keyStores);
    }

    public int hashCode() {
        return Objects.hash(this.certificates, this.keyStores);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AuthUserCertificates {\n");
        sb.append("    certificates: ").append(this.toIndentedString(this.certificates)).append("\n");
        sb.append("    keyStores: ").append(this.toIndentedString(this.keyStores)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

