/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Schema(description="A document history entry wrapping one manipulation state of a document.")
@JsonPropertyOrder(value={"active", "dateTime", "fileName", "id", "operation"})
@JsonTypeName(value="Document_HistoryEntry")
public class DocumentHistoryEntry {
    public static final String JSON_PROPERTY_ACTIVE = "active";
    private Boolean active = false;
    public static final String JSON_PROPERTY_DATE_TIME = "dateTime";
    private String dateTime = "";
    public static final String JSON_PROPERTY_FILE_NAME = "fileName";
    private String fileName = "";
    public static final String JSON_PROPERTY_ID = "id";
    private Integer id = 0;
    public static final String JSON_PROPERTY_OPERATION = "operation";
    private String operation = "";

    public DocumentHistoryEntry() {
    }

    @JsonCreator
    public DocumentHistoryEntry(@JsonProperty(value="dateTime") String dateTime, @JsonProperty(value="fileName") String fileName, @JsonProperty(value="id") Integer id) {
        this();
        this.dateTime = dateTime;
        this.fileName = fileName;
        this.id = id;
    }

    public DocumentHistoryEntry active(Boolean active) {
        this.active = active;
        return this;
    }

    @Schema(name="When this is set to **true** the entry is still active and may be reverted to.")
    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getActive() {
        return this.active;
    }

    @JsonProperty(value="active")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setActive(Boolean active) {
        this.active = active;
    }

    @Schema(example="2022-05-16T11:30:33+0200", name="The creation time of the entry.")
    @JsonProperty(value="dateTime")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getDateTime() {
        return this.dateTime;
    }

    @Schema(name="The file name used for this entry.")
    @JsonProperty(value="fileName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getFileName() {
        return this.fileName;
    }

    @Schema(required=true, name="The unique history id in the server\u00b4s **document storage**.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public Integer getId() {
        return this.id;
    }

    public DocumentHistoryEntry operation(String operation) {
        this.operation = operation;
        return this;
    }

    @Schema(example="One of: DOCUMENT:UPLOAD, TOOLBOX:ROTATE, TOOLBOX:DELETE, TOOLBOX:SPLIT, TOOLBOX:OPTIONS, TOOLBOX:MERGE, TOOLBOX:WATERMARK, TOOLBOX:ATTACHMENT, TOOLBOX:EXTRACTION, TOOLBOX:IMAGES, TOOLBOX:FORMS, TOOLBOX:ANNOTATION, TOOLBOX:REDACT, TOOLBOX:DESCRIPTION, TOOLBOX:MOVE, TOOLBOX:OUTLINE, TOOLBOX:PORTFOLIO, TOOLBOX:ENCRYPTION, TOOLBOX:COMPRESS TOOLBOX:SCALE, PDFA, OCR, SIGNATURE", name="The name of the operation executed for the entry. (The name of the webservice - optionally followed by ':' and the name of the executed operation.)")
    @JsonProperty(value="operation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getOperation() {
        return this.operation;
    }

    @JsonProperty(value="operation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOperation(String operation) {
        this.operation = operation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentHistoryEntry documentHistoryEntry = (DocumentHistoryEntry)o;
        return Objects.equals(this.active, documentHistoryEntry.active) && Objects.equals(this.dateTime, documentHistoryEntry.dateTime) && Objects.equals(this.fileName, documentHistoryEntry.fileName) && Objects.equals(this.id, documentHistoryEntry.id) && Objects.equals(this.operation, documentHistoryEntry.operation);
    }

    public int hashCode() {
        return Objects.hash(this.active, this.dateTime, this.fileName, this.id, this.operation);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentHistoryEntry {\n");
        sb.append("    active: ").append(this.toIndentedString(this.active)).append("\n");
        sb.append("    dateTime: ").append(this.toIndentedString(this.dateTime)).append("\n");
        sb.append("    fileName: ").append(this.toIndentedString(this.fileName)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    operation: ").append(this.toIndentedString(this.operation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

