/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.DocumentInfoFormXfaField;
import org.jetbrains.annotations.Nullable;

@Schema(description="Provides field information for a single field in the form of the PDF document")
@JsonPropertyOrder(value={"dataXPath", "fullyQualifiedName", "xfaField"})
@JsonTypeName(value="Document_InfoFormField")
public class DocumentInfoFormField {
    public static final String JSON_PROPERTY_DATA_X_PATH = "dataXPath";
    private String dataXPath = "";
    public static final String JSON_PROPERTY_FULLY_QUALIFIED_NAME = "fullyQualifiedName";
    private String fullyQualifiedName = "";
    public static final String JSON_PROPERTY_XFA_FIELD = "xfaField";
    private DocumentInfoFormXfaField xfaField;

    public DocumentInfoFormField() {
    }

    @JsonCreator
    public DocumentInfoFormField(@JsonProperty(value="dataXPath") String dataXPath, @JsonProperty(value="fullyQualifiedName") String fullyQualifiedName) {
        this();
        this.dataXPath = dataXPath;
        this.fullyQualifiedName = fullyQualifiedName;
    }

    @Schema(name="XPath to the entry in the XML data structure used for importing and exporting data to the form.")
    @JsonProperty(value="dataXPath")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getDataXPath() {
        return this.dataXPath;
    }

    @Schema(name="Fully qualified field name")
    @JsonProperty(value="fullyQualifiedName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    public DocumentInfoFormField xfaField(DocumentInfoFormXfaField xfaField) {
        this.xfaField = xfaField;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="xfaField")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public DocumentInfoFormXfaField getXfaField() {
        return this.xfaField;
    }

    @JsonProperty(value="xfaField")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setXfaField(DocumentInfoFormXfaField xfaField) {
        this.xfaField = xfaField;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentInfoFormField documentInfoFormField = (DocumentInfoFormField)o;
        return Objects.equals(this.dataXPath, documentInfoFormField.dataXPath) && Objects.equals(this.fullyQualifiedName, documentInfoFormField.fullyQualifiedName) && Objects.equals(this.xfaField, documentInfoFormField.xfaField);
    }

    public int hashCode() {
        return Objects.hash(this.dataXPath, this.fullyQualifiedName, this.xfaField);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentInfoFormField {\n");
        sb.append("    dataXPath: ").append(this.toIndentedString(this.dataXPath)).append("\n");
        sb.append("    fullyQualifiedName: ").append(this.toIndentedString(this.fullyQualifiedName)).append("\n");
        sb.append("    xfaField: ").append(this.toIndentedString(this.xfaField)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

