/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Contains recipient information")
@JsonPropertyOrder(value={"issuer", "serialNumber"})
@JsonTypeName(value="Document_Recipient")
public class DocumentRecipient {
    public static final String JSON_PROPERTY_ISSUER = "issuer";
    private String issuer = "";
    public static final String JSON_PROPERTY_SERIAL_NUMBER = "serialNumber";
    private String serialNumber = "";

    public DocumentRecipient() {
    }

    @JsonCreator
    public DocumentRecipient(@JsonProperty(value="issuer") String issuer, @JsonProperty(value="serialNumber") String serialNumber) {
        this();
        this.issuer = issuer;
        this.serialNumber = serialNumber;
    }

    @Schema(name="The X.500 name of the recipient")
    @JsonProperty(value="issuer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getIssuer() {
        return this.issuer;
    }

    @Schema(name="The serial number of the recipient's X.500 certificate")
    @JsonProperty(value="serialNumber")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getSerialNumber() {
        return this.serialNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentRecipient documentRecipient = (DocumentRecipient)o;
        return Objects.equals(this.issuer, documentRecipient.issuer) && Objects.equals(this.serialNumber, documentRecipient.serialNumber);
    }

    public int hashCode() {
        return Objects.hash(this.issuer, this.serialNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentRecipient {\n");
        sb.append("    issuer: ").append(this.toIndentedString(this.issuer)).append("\n");
        sb.append("    serialNumber: ").append(this.toIndentedString(this.serialNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

