/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.MetadataPieceInfoBackgroundContent;
import net.webpdf.wsclient.openapi.MetadataRectangle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Schema(description="An element of this type defines a background for a page of the document.")
@JsonPropertyOrder(value={"bounds", "isImage", "objectKey", "onprint", "onscreen", "page", "pieceInfo"})
@JsonTypeName(value="Metadata_BackgroundContent")
public class MetadataBackgroundContent {
    public static final String JSON_PROPERTY_BOUNDS = "bounds";
    private MetadataRectangle bounds;
    public static final String JSON_PROPERTY_IS_IMAGE = "isImage";
    private Boolean isImage = false;
    public static final String JSON_PROPERTY_OBJECT_KEY = "objectKey";
    private String objectKey = "";
    public static final String JSON_PROPERTY_ONPRINT = "onprint";
    private Boolean onprint = true;
    public static final String JSON_PROPERTY_ONSCREEN = "onscreen";
    private Boolean onscreen = true;
    public static final String JSON_PROPERTY_PAGE = "page";
    private Integer page = 0;
    public static final String JSON_PROPERTY_PIECE_INFO = "pieceInfo";
    private MetadataPieceInfoBackgroundContent pieceInfo;

    public MetadataBackgroundContent bounds(MetadataRectangle bounds) {
        this.bounds = bounds;
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="bounds")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public MetadataRectangle getBounds() {
        return this.bounds;
    }

    @JsonProperty(value="bounds")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setBounds(MetadataRectangle bounds) {
        this.bounds = bounds;
    }

    public MetadataBackgroundContent isImage(Boolean isImage) {
        this.isImage = isImage;
        return this;
    }

    @Schema(name="When set to true, the background is using an image resource. (Otherwise it is unicolor)")
    @JsonProperty(value="isImage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getIsImage() {
        return this.isImage;
    }

    @JsonProperty(value="isImage")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIsImage(Boolean isImage) {
        this.isImage = isImage;
    }

    public MetadataBackgroundContent objectKey(String objectKey) {
        this.objectKey = objectKey;
        return this;
    }

    @Schema(name="The object ID of the background. **Info:** A PDF object ID consists of two numbers, where the first number selects the object's number and the second the \"generation\" of the object. The object ID shall always be unique within the context of the document and can be used to select a specific object.")
    @JsonProperty(value="objectKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getObjectKey() {
        return this.objectKey;
    }

    @JsonProperty(value="objectKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setObjectKey(String objectKey) {
        this.objectKey = objectKey;
    }

    public MetadataBackgroundContent onprint(Boolean onprint) {
        this.onprint = onprint;
        return this;
    }

    @Schema(name="Whether the background shall be visible in printouts of the document.")
    @JsonProperty(value="onprint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getOnprint() {
        return this.onprint;
    }

    @JsonProperty(value="onprint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOnprint(Boolean onprint) {
        this.onprint = onprint;
    }

    public MetadataBackgroundContent onscreen(Boolean onscreen) {
        this.onscreen = onscreen;
        return this;
    }

    @Schema(name="Whether the background shall be visible in Readers.")
    @JsonProperty(value="onscreen")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getOnscreen() {
        return this.onscreen;
    }

    @JsonProperty(value="onscreen")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOnscreen(Boolean onscreen) {
        this.onscreen = onscreen;
    }

    public MetadataBackgroundContent page(Integer page) {
        this.page = page;
        return this;
    }

    @Schema(name="The page the background shall be set for.")
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPage(Integer page) {
        this.page = page;
    }

    public MetadataBackgroundContent pieceInfo(MetadataPieceInfoBackgroundContent pieceInfo) {
        this.pieceInfo = pieceInfo;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="pieceInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public MetadataPieceInfoBackgroundContent getPieceInfo() {
        return this.pieceInfo;
    }

    @JsonProperty(value="pieceInfo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPieceInfo(MetadataPieceInfoBackgroundContent pieceInfo) {
        this.pieceInfo = pieceInfo;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataBackgroundContent metadataBackgroundContent = (MetadataBackgroundContent)o;
        return Objects.equals(this.bounds, metadataBackgroundContent.bounds) && Objects.equals(this.isImage, metadataBackgroundContent.isImage) && Objects.equals(this.objectKey, metadataBackgroundContent.objectKey) && Objects.equals(this.onprint, metadataBackgroundContent.onprint) && Objects.equals(this.onscreen, metadataBackgroundContent.onscreen) && Objects.equals(this.page, metadataBackgroundContent.page) && Objects.equals(this.pieceInfo, metadataBackgroundContent.pieceInfo);
    }

    public int hashCode() {
        return Objects.hash(this.bounds, this.isImage, this.objectKey, this.onprint, this.onscreen, this.page, this.pieceInfo);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetadataBackgroundContent {\n");
        sb.append("    bounds: ").append(this.toIndentedString(this.bounds)).append("\n");
        sb.append("    isImage: ").append(this.toIndentedString(this.isImage)).append("\n");
        sb.append("    objectKey: ").append(this.toIndentedString(this.objectKey)).append("\n");
        sb.append("    onprint: ").append(this.toIndentedString(this.onprint)).append("\n");
        sb.append("    onscreen: ").append(this.toIndentedString(this.onscreen)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    pieceInfo: ").append(this.toIndentedString(this.pieceInfo)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

