/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines a folder for a PDF collection (portfolio).")
@JsonPropertyOrder(value={"creationDate", "id", "modificationDate", "name", "path"})
@JsonTypeName(value="Metadata_Folder")
public class MetadataFolder {
    public static final String JSON_PROPERTY_CREATION_DATE = "creationDate";
    private String creationDate = "";
    public static final String JSON_PROPERTY_ID = "id";
    private Integer id = 0;
    public static final String JSON_PROPERTY_MODIFICATION_DATE = "modificationDate";
    private String modificationDate = "";
    public static final String JSON_PROPERTY_NAME = "name";
    private String name = "";
    public static final String JSON_PROPERTY_PATH = "path";
    private String path = "";

    public MetadataFolder creationDate(String creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @Schema(name="The date of the folder's creation.")
    @JsonProperty(value="creationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getCreationDate() {
        return this.creationDate;
    }

    @JsonProperty(value="creationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public MetadataFolder id(Integer id) {
        this.id = id;
        return this;
    }

    @Schema(name="The numeric folder ID of the portfolio folder.")
    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setId(Integer id) {
        this.id = id;
    }

    public MetadataFolder modificationDate(String modificationDate) {
        this.modificationDate = modificationDate;
        return this;
    }

    @Schema(name="The date of the last modification of the folder.")
    @JsonProperty(value="modificationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getModificationDate() {
        return this.modificationDate;
    }

    @JsonProperty(value="modificationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setModificationDate(String modificationDate) {
        this.modificationDate = modificationDate;
    }

    public MetadataFolder name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="The name of the folder.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public MetadataFolder path(String path) {
        this.path = path;
        return this;
    }

    @Schema(name="The path the folder is positioned at.")
    @JsonProperty(value="path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getPath() {
        return this.path;
    }

    @JsonProperty(value="path")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPath(String path) {
        this.path = path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataFolder metadataFolder = (MetadataFolder)o;
        return Objects.equals(this.creationDate, metadataFolder.creationDate) && Objects.equals(this.id, metadataFolder.id) && Objects.equals(this.modificationDate, metadataFolder.modificationDate) && Objects.equals(this.name, metadataFolder.name) && Objects.equals(this.path, metadataFolder.path);
    }

    public int hashCode() {
        return Objects.hash(this.creationDate, this.id, this.modificationDate, this.name, this.path);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetadataFolder {\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    modificationDate: ").append(this.toIndentedString(this.modificationDate)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    path: ").append(this.toIndentedString(this.path)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

