/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.webpdf.wsclient.openapi.MetadataFolder;
import org.jetbrains.annotations.Nullable;

@Schema(description="Lists the folders contained in a PDF collection (portfolio), that are used to structure the embedded attachments.")
@JsonPropertyOrder(value={"folder", "initialFile"})
@JsonTypeName(value="Metadata_FoldersDocument")
public class MetadataFoldersDocument {
    public static final String JSON_PROPERTY_FOLDER = "folder";
    private List<MetadataFolder> folder = null;
    public static final String JSON_PROPERTY_INITIAL_FILE = "initialFile";
    private String initialFile = "";

    public MetadataFoldersDocument folder(List<MetadataFolder> folder) {
        this.folder = folder;
        return this;
    }

    public MetadataFoldersDocument addFolderItem(MetadataFolder folderItem) {
        if (this.folder == null) {
            this.folder = new ArrayList<MetadataFolder>();
        }
        this.folder.add(folderItem);
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="folder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public List<MetadataFolder> getFolder() {
        return this.folder;
    }

    @JsonProperty(value="folder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFolder(List<MetadataFolder> folder) {
        this.folder = folder;
    }

    public MetadataFoldersDocument initialFile(String initialFile) {
        this.initialFile = initialFile;
        return this;
    }

    @Schema(name="The object ID of the initially visible attachment.  **Info:** A PDF object ID consists of two numbers, where the first number selects the object's number and the second the \"generation\" of the object. The object ID shall always be unique within the context of the document and can be used to select a specific object.")
    @JsonProperty(value="initialFile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getInitialFile() {
        return this.initialFile;
    }

    @JsonProperty(value="initialFile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInitialFile(String initialFile) {
        this.initialFile = initialFile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataFoldersDocument metadataFoldersDocument = (MetadataFoldersDocument)o;
        return Objects.equals(this.folder, metadataFoldersDocument.folder) && Objects.equals(this.initialFile, metadataFoldersDocument.initialFile);
    }

    public int hashCode() {
        return Objects.hash(this.folder, this.initialFile);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetadataFoldersDocument {\n");
        sb.append("    folder: ").append(this.toIndentedString(this.folder)).append("\n");
        sb.append("    initialFile: ").append(this.toIndentedString(this.initialFile)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

