/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.MetadataRelationMarkup;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines a set of attributes for text markup annotations.")
@JsonPropertyOrder(value={"creationDate", "creator", "intents", "opacity", "relation", "richContents", "subject"})
@JsonTypeName(value="Metadata_Markup")
public class MetadataMarkup {
    public static final String JSON_PROPERTY_CREATION_DATE = "creationDate";
    private String creationDate = "";
    public static final String JSON_PROPERTY_CREATOR = "creator";
    private String creator = "";
    public static final String JSON_PROPERTY_INTENTS = "intents";
    private String intents = "";
    public static final String JSON_PROPERTY_OPACITY = "opacity";
    private Integer opacity = 100;
    public static final String JSON_PROPERTY_RELATION = "relation";
    private MetadataRelationMarkup relation;
    public static final String JSON_PROPERTY_RICH_CONTENTS = "richContents";
    private String richContents = "";
    public static final String JSON_PROPERTY_SUBJECT = "subject";
    private String subject = "";

    public MetadataMarkup creationDate(String creationDate) {
        this.creationDate = creationDate;
        return this;
    }

    @Schema(name="The date of the annotation's creation. This string will contain the date in ASN.1 standard format. (D:YYYYMMDDHHmmSSOHH'mm)")
    @JsonProperty(value="creationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getCreationDate() {
        return this.creationDate;
    }

    @JsonProperty(value="creationDate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreationDate(String creationDate) {
        this.creationDate = creationDate;
    }

    public MetadataMarkup creator(String creator) {
        this.creator = creator;
        return this;
    }

    @Schema(name="The name of the annotation's author.")
    @JsonProperty(value="creator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getCreator() {
        return this.creator;
    }

    @JsonProperty(value="creator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreator(String creator) {
        this.creator = creator;
    }

    public MetadataMarkup intents(String intents) {
        this.intents = intents;
        return this;
    }

    @Schema(name="The annotation's intents. Depending on the annotation sub type the intents value shall serve further purposes.")
    @JsonProperty(value="intents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getIntents() {
        return this.intents;
    }

    @JsonProperty(value="intents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIntents(String intents) {
        this.intents = intents;
    }

    public MetadataMarkup opacity(Integer opacity) {
        this.opacity = opacity;
        return this;
    }

    @Schema(name="The annotations opacity as a percentage, where 100 is fully oqaque and 0 is fully transparent.")
    @JsonProperty(value="opacity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getOpacity() {
        return this.opacity;
    }

    @JsonProperty(value="opacity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOpacity(Integer opacity) {
        this.opacity = opacity;
    }

    public MetadataMarkup relation(MetadataRelationMarkup relation) {
        this.relation = relation;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="relation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public MetadataRelationMarkup getRelation() {
        return this.relation;
    }

    @JsonProperty(value="relation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRelation(MetadataRelationMarkup relation) {
        this.relation = relation;
    }

    public MetadataMarkup richContents(String richContents) {
        this.richContents = richContents;
        return this;
    }

    @Schema(name="A richtext string containing defining style and contents of the annotation. (This String shall conform to the richtext conventions of the XML Forms Specification (XFA)).")
    @JsonProperty(value="richContents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getRichContents() {
        return this.richContents;
    }

    @JsonProperty(value="richContents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRichContents(String richContents) {
        this.richContents = richContents;
    }

    public MetadataMarkup subject(String subject) {
        this.subject = subject;
        return this;
    }

    @Schema(name="The annotation's subject.")
    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubject(String subject) {
        this.subject = subject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataMarkup metadataMarkup = (MetadataMarkup)o;
        return Objects.equals(this.creationDate, metadataMarkup.creationDate) && Objects.equals(this.creator, metadataMarkup.creator) && Objects.equals(this.intents, metadataMarkup.intents) && Objects.equals(this.opacity, metadataMarkup.opacity) && Objects.equals(this.relation, metadataMarkup.relation) && Objects.equals(this.richContents, metadataMarkup.richContents) && Objects.equals(this.subject, metadataMarkup.subject);
    }

    public int hashCode() {
        return Objects.hash(this.creationDate, this.creator, this.intents, this.opacity, this.relation, this.richContents, this.subject);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetadataMarkup {\n");
        sb.append("    creationDate: ").append(this.toIndentedString(this.creationDate)).append("\n");
        sb.append("    creator: ").append(this.toIndentedString(this.creator)).append("\n");
        sb.append("    intents: ").append(this.toIndentedString(this.intents)).append("\n");
        sb.append("    opacity: ").append(this.toIndentedString(this.opacity)).append("\n");
        sb.append("    relation: ").append(this.toIndentedString(this.relation)).append("\n");
        sb.append("    richContents: ").append(this.toIndentedString(this.richContents)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

