/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="An element of this type shall contain information concerning the used encryption and the used encryption key.")
@JsonPropertyOrder(value={"hasAsymmetricEncryption", "hasOpenPassword", "hasPermissionPassword", "keyAlgorithm", "keyLength"})
@JsonTypeName(value="Metadata_Password")
public class MetadataPassword {
    public static final String JSON_PROPERTY_HAS_ASYMMETRIC_ENCRYPTION = "hasAsymmetricEncryption";
    private Boolean hasAsymmetricEncryption = false;
    public static final String JSON_PROPERTY_HAS_OPEN_PASSWORD = "hasOpenPassword";
    private Boolean hasOpenPassword = false;
    public static final String JSON_PROPERTY_HAS_PERMISSION_PASSWORD = "hasPermissionPassword";
    private Boolean hasPermissionPassword = false;
    public static final String JSON_PROPERTY_KEY_ALGORITHM = "keyAlgorithm";
    private KeyAlgorithmEnum keyAlgorithm = KeyAlgorithmEnum.NONE;
    public static final String JSON_PROPERTY_KEY_LENGTH = "keyLength";
    private Integer keyLength = 0;

    public MetadataPassword hasAsymmetricEncryption(Boolean hasAsymmetricEncryption) {
        this.hasAsymmetricEncryption = hasAsymmetricEncryption;
        return this;
    }

    @Schema(name="If this is set to \"true\", the document is asymmetrically encrypted and a matching private key is required to decrypt it. Otherwise the document is symetrically encrypted and requires a password.")
    @JsonProperty(value="hasAsymmetricEncryption")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getHasAsymmetricEncryption() {
        return this.hasAsymmetricEncryption;
    }

    @JsonProperty(value="hasAsymmetricEncryption")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasAsymmetricEncryption(Boolean hasAsymmetricEncryption) {
        this.hasAsymmetricEncryption = hasAsymmetricEncryption;
    }

    public MetadataPassword hasOpenPassword(Boolean hasOpenPassword) {
        this.hasOpenPassword = hasOpenPassword;
        return this;
    }

    @Schema(name="If this is set to \"true\", the document is encrypted and requires a password to be opened.")
    @JsonProperty(value="hasOpenPassword")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getHasOpenPassword() {
        return this.hasOpenPassword;
    }

    @JsonProperty(value="hasOpenPassword")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasOpenPassword(Boolean hasOpenPassword) {
        this.hasOpenPassword = hasOpenPassword;
    }

    public MetadataPassword hasPermissionPassword(Boolean hasPermissionPassword) {
        this.hasPermissionPassword = hasPermissionPassword;
        return this;
    }

    @Schema(name="If this is set to \"true\", the document has a change protection and a password is required to claim ownership and modify the document.")
    @JsonProperty(value="hasPermissionPassword")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getHasPermissionPassword() {
        return this.hasPermissionPassword;
    }

    @JsonProperty(value="hasPermissionPassword")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHasPermissionPassword(Boolean hasPermissionPassword) {
        this.hasPermissionPassword = hasPermissionPassword;
    }

    public MetadataPassword keyAlgorithm(KeyAlgorithmEnum keyAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
        return this;
    }

    @Schema(name="The algorithm used for encryption.  *   none = The document is not encrypted. *   aes = The document has been encrypted using the Advanced Encryption Standard. *   rc4 = The document has been encrypted using the RC4 cipher.")
    @JsonProperty(value="keyAlgorithm")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public KeyAlgorithmEnum getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    @JsonProperty(value="keyAlgorithm")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setKeyAlgorithm(KeyAlgorithmEnum keyAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
    }

    public MetadataPassword keyLength(Integer keyLength) {
        this.keyLength = keyLength;
        return this;
    }

    @Schema(name="The Bit length of the key used for encryption.")
    @JsonProperty(value="keyLength")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getKeyLength() {
        return this.keyLength;
    }

    @JsonProperty(value="keyLength")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setKeyLength(Integer keyLength) {
        this.keyLength = keyLength;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetadataPassword metadataPassword = (MetadataPassword)o;
        return Objects.equals(this.hasAsymmetricEncryption, metadataPassword.hasAsymmetricEncryption) && Objects.equals(this.hasOpenPassword, metadataPassword.hasOpenPassword) && Objects.equals(this.hasPermissionPassword, metadataPassword.hasPermissionPassword) && Objects.equals((Object)this.keyAlgorithm, (Object)metadataPassword.keyAlgorithm) && Objects.equals(this.keyLength, metadataPassword.keyLength);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.hasAsymmetricEncryption, this.hasOpenPassword, this.hasPermissionPassword, this.keyAlgorithm, this.keyLength});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MetadataPassword {\n");
        sb.append("    hasAsymmetricEncryption: ").append(this.toIndentedString(this.hasAsymmetricEncryption)).append("\n");
        sb.append("    hasOpenPassword: ").append(this.toIndentedString(this.hasOpenPassword)).append("\n");
        sb.append("    hasPermissionPassword: ").append(this.toIndentedString(this.hasPermissionPassword)).append("\n");
        sb.append("    keyAlgorithm: ").append(this.toIndentedString((Object)this.keyAlgorithm)).append("\n");
        sb.append("    keyLength: ").append(this.toIndentedString(this.keyLength)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum KeyAlgorithmEnum {
        NONE("none"),
        AES("aes"),
        RC4("rc4");

        private String value;

        private KeyAlgorithmEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static KeyAlgorithmEnum fromValue(String value) {
            for (KeyAlgorithmEnum b : KeyAlgorithmEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

