/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Schema(description="OpenID configuration provider metadata")
@JsonPropertyOrder(value={"authorization_endpoint", "claims_supported", "grant_types_supported", "id_token_signing_alg_values_supported", "issuer", "jwks_uri", "response_types_supported", "scopes_supported", "subject_types_supported", "token_endpoint", "userinfo_endpoint"})
@JsonTypeName(value="OAuth_OIDCMetadata")
public class OAuthOIDCMetadata {
    public static final String JSON_PROPERTY_AUTHORIZATION_ENDPOINT = "authorization_endpoint";
    private String authorizationEndpoint = "";
    public static final String JSON_PROPERTY_CLAIMS_SUPPORTED = "claims_supported";
    private List<String> claimsSupported = null;
    public static final String JSON_PROPERTY_GRANT_TYPES_SUPPORTED = "grant_types_supported";
    private List<String> grantTypesSupported = null;
    public static final String JSON_PROPERTY_ID_TOKEN_SIGNING_ALG_VALUES_SUPPORTED = "id_token_signing_alg_values_supported";
    private List<String> idTokenSigningAlgValuesSupported = new ArrayList<String>();
    public static final String JSON_PROPERTY_ISSUER = "issuer";
    private String issuer = "";
    public static final String JSON_PROPERTY_JWKS_URI = "jwks_uri";
    private String jwksUri = "";
    public static final String JSON_PROPERTY_RESPONSE_TYPES_SUPPORTED = "response_types_supported";
    private List<String> responseTypesSupported = new ArrayList<String>();
    public static final String JSON_PROPERTY_SCOPES_SUPPORTED = "scopes_supported";
    private List<String> scopesSupported = null;
    public static final String JSON_PROPERTY_SUBJECT_TYPES_SUPPORTED = "subject_types_supported";
    private List<String> subjectTypesSupported = new ArrayList<String>();
    public static final String JSON_PROPERTY_TOKEN_ENDPOINT = "token_endpoint";
    private String tokenEndpoint = "";
    public static final String JSON_PROPERTY_USERINFO_ENDPOINT = "userinfo_endpoint";
    private String userinfoEndpoint = "";

    public OAuthOIDCMetadata authorizationEndpoint(String authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="authorization_endpoint")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public String getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    @JsonProperty(value="authorization_endpoint")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAuthorizationEndpoint(String authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
    }

    public OAuthOIDCMetadata claimsSupported(List<String> claimsSupported) {
        this.claimsSupported = claimsSupported;
        return this;
    }

    public OAuthOIDCMetadata addClaimsSupportedItem(String claimsSupportedItem) {
        if (this.claimsSupported == null) {
            this.claimsSupported = new ArrayList<String>();
        }
        this.claimsSupported.add(claimsSupportedItem);
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="claims_supported")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public List<String> getClaimsSupported() {
        return this.claimsSupported;
    }

    @JsonProperty(value="claims_supported")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setClaimsSupported(List<String> claimsSupported) {
        this.claimsSupported = claimsSupported;
    }

    public OAuthOIDCMetadata grantTypesSupported(List<String> grantTypesSupported) {
        this.grantTypesSupported = grantTypesSupported;
        return this;
    }

    public OAuthOIDCMetadata addGrantTypesSupportedItem(String grantTypesSupportedItem) {
        if (this.grantTypesSupported == null) {
            this.grantTypesSupported = new ArrayList<String>();
        }
        this.grantTypesSupported.add(grantTypesSupportedItem);
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="grant_types_supported")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public List<String> getGrantTypesSupported() {
        return this.grantTypesSupported;
    }

    @JsonProperty(value="grant_types_supported")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGrantTypesSupported(List<String> grantTypesSupported) {
        this.grantTypesSupported = grantTypesSupported;
    }

    public OAuthOIDCMetadata idTokenSigningAlgValuesSupported(List<String> idTokenSigningAlgValuesSupported) {
        this.idTokenSigningAlgValuesSupported = idTokenSigningAlgValuesSupported;
        return this;
    }

    public OAuthOIDCMetadata addIdTokenSigningAlgValuesSupportedItem(String idTokenSigningAlgValuesSupportedItem) {
        this.idTokenSigningAlgValuesSupported.add(idTokenSigningAlgValuesSupportedItem);
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="id_token_signing_alg_values_supported")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public List<String> getIdTokenSigningAlgValuesSupported() {
        return this.idTokenSigningAlgValuesSupported;
    }

    @JsonProperty(value="id_token_signing_alg_values_supported")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdTokenSigningAlgValuesSupported(List<String> idTokenSigningAlgValuesSupported) {
        this.idTokenSigningAlgValuesSupported = idTokenSigningAlgValuesSupported;
    }

    public OAuthOIDCMetadata issuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="issuer")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public String getIssuer() {
        return this.issuer;
    }

    @JsonProperty(value="issuer")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public OAuthOIDCMetadata jwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="jwks_uri")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public String getJwksUri() {
        return this.jwksUri;
    }

    @JsonProperty(value="jwks_uri")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
    }

    public OAuthOIDCMetadata responseTypesSupported(List<String> responseTypesSupported) {
        this.responseTypesSupported = responseTypesSupported;
        return this;
    }

    public OAuthOIDCMetadata addResponseTypesSupportedItem(String responseTypesSupportedItem) {
        this.responseTypesSupported.add(responseTypesSupportedItem);
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="response_types_supported")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public List<String> getResponseTypesSupported() {
        return this.responseTypesSupported;
    }

    @JsonProperty(value="response_types_supported")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setResponseTypesSupported(List<String> responseTypesSupported) {
        this.responseTypesSupported = responseTypesSupported;
    }

    public OAuthOIDCMetadata scopesSupported(List<String> scopesSupported) {
        this.scopesSupported = scopesSupported;
        return this;
    }

    public OAuthOIDCMetadata addScopesSupportedItem(String scopesSupportedItem) {
        if (this.scopesSupported == null) {
            this.scopesSupported = new ArrayList<String>();
        }
        this.scopesSupported.add(scopesSupportedItem);
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="scopes_supported")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public List<String> getScopesSupported() {
        return this.scopesSupported;
    }

    @JsonProperty(value="scopes_supported")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScopesSupported(List<String> scopesSupported) {
        this.scopesSupported = scopesSupported;
    }

    public OAuthOIDCMetadata subjectTypesSupported(List<String> subjectTypesSupported) {
        this.subjectTypesSupported = subjectTypesSupported;
        return this;
    }

    public OAuthOIDCMetadata addSubjectTypesSupportedItem(String subjectTypesSupportedItem) {
        this.subjectTypesSupported.add(subjectTypesSupportedItem);
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="subject_types_supported")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public List<String> getSubjectTypesSupported() {
        return this.subjectTypesSupported;
    }

    @JsonProperty(value="subject_types_supported")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSubjectTypesSupported(List<String> subjectTypesSupported) {
        this.subjectTypesSupported = subjectTypesSupported;
    }

    public OAuthOIDCMetadata tokenEndpoint(String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="token_endpoint")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    @JsonProperty(value="token_endpoint")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTokenEndpoint(String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
    }

    public OAuthOIDCMetadata userinfoEndpoint(String userinfoEndpoint) {
        this.userinfoEndpoint = userinfoEndpoint;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="userinfo_endpoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getUserinfoEndpoint() {
        return this.userinfoEndpoint;
    }

    @JsonProperty(value="userinfo_endpoint")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserinfoEndpoint(String userinfoEndpoint) {
        this.userinfoEndpoint = userinfoEndpoint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuthOIDCMetadata oauthOIDCMetadata = (OAuthOIDCMetadata)o;
        return Objects.equals(this.authorizationEndpoint, oauthOIDCMetadata.authorizationEndpoint) && Objects.equals(this.claimsSupported, oauthOIDCMetadata.claimsSupported) && Objects.equals(this.grantTypesSupported, oauthOIDCMetadata.grantTypesSupported) && Objects.equals(this.idTokenSigningAlgValuesSupported, oauthOIDCMetadata.idTokenSigningAlgValuesSupported) && Objects.equals(this.issuer, oauthOIDCMetadata.issuer) && Objects.equals(this.jwksUri, oauthOIDCMetadata.jwksUri) && Objects.equals(this.responseTypesSupported, oauthOIDCMetadata.responseTypesSupported) && Objects.equals(this.scopesSupported, oauthOIDCMetadata.scopesSupported) && Objects.equals(this.subjectTypesSupported, oauthOIDCMetadata.subjectTypesSupported) && Objects.equals(this.tokenEndpoint, oauthOIDCMetadata.tokenEndpoint) && Objects.equals(this.userinfoEndpoint, oauthOIDCMetadata.userinfoEndpoint);
    }

    public int hashCode() {
        return Objects.hash(this.authorizationEndpoint, this.claimsSupported, this.grantTypesSupported, this.idTokenSigningAlgValuesSupported, this.issuer, this.jwksUri, this.responseTypesSupported, this.scopesSupported, this.subjectTypesSupported, this.tokenEndpoint, this.userinfoEndpoint);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OAuthOIDCMetadata {\n");
        sb.append("    authorizationEndpoint: ").append(this.toIndentedString(this.authorizationEndpoint)).append("\n");
        sb.append("    claimsSupported: ").append(this.toIndentedString(this.claimsSupported)).append("\n");
        sb.append("    grantTypesSupported: ").append(this.toIndentedString(this.grantTypesSupported)).append("\n");
        sb.append("    idTokenSigningAlgValuesSupported: ").append(this.toIndentedString(this.idTokenSigningAlgValuesSupported)).append("\n");
        sb.append("    issuer: ").append(this.toIndentedString(this.issuer)).append("\n");
        sb.append("    jwksUri: ").append(this.toIndentedString(this.jwksUri)).append("\n");
        sb.append("    responseTypesSupported: ").append(this.toIndentedString(this.responseTypesSupported)).append("\n");
        sb.append("    scopesSupported: ").append(this.toIndentedString(this.scopesSupported)).append("\n");
        sb.append("    subjectTypesSupported: ").append(this.toIndentedString(this.subjectTypesSupported)).append("\n");
        sb.append("    tokenEndpoint: ").append(this.toIndentedString(this.tokenEndpoint)).append("\n");
        sb.append("    userinfoEndpoint: ").append(this.toIndentedString(this.userinfoEndpoint)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

