/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationAppearanceAdd;
import net.webpdf.wsclient.openapi.OperationSignerAdd;
import org.jetbrains.annotations.Nullable;

@Schema(description="Used to add a new signature to the PDF document.")
@JsonPropertyOrder(value={"appearance", "appendSignature", "certificationLevel", "contact", "fieldName", "keyName", "keyPassword", "location", "reason", "signer"})
@JsonTypeName(value="Operation_AddSignature")
public class OperationAddSignature {
    public static final String JSON_PROPERTY_APPEARANCE = "appearance";
    private OperationAppearanceAdd appearance;
    public static final String JSON_PROPERTY_APPEND_SIGNATURE = "appendSignature";
    private Boolean appendSignature = false;
    public static final String JSON_PROPERTY_CERTIFICATION_LEVEL = "certificationLevel";
    private CertificationLevelEnum certificationLevel = CertificationLevelEnum.NOCHANGES;
    public static final String JSON_PROPERTY_CONTACT = "contact";
    private String contact = "";
    public static final String JSON_PROPERTY_FIELD_NAME = "fieldName";
    private String fieldName = "Signature1";
    public static final String JSON_PROPERTY_KEY_NAME = "keyName";
    private String keyName = "";
    public static final String JSON_PROPERTY_KEY_PASSWORD = "keyPassword";
    private String keyPassword = "";
    public static final String JSON_PROPERTY_LOCATION = "location";
    private String location = "";
    public static final String JSON_PROPERTY_REASON = "reason";
    private String reason = "";
    public static final String JSON_PROPERTY_SIGNER = "signer";
    private OperationSignerAdd signer;

    public OperationAddSignature appearance(OperationAppearanceAdd appearance) {
        this.appearance = appearance;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="appearance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationAppearanceAdd getAppearance() {
        return this.appearance;
    }

    @JsonProperty(value="appearance")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAppearance(OperationAppearanceAdd appearance) {
        this.appearance = appearance;
    }

    public OperationAddSignature appendSignature(Boolean appendSignature) {
        this.appendSignature = appendSignature;
        return this;
    }

    @Schema(name="**Deprecated:** Usage of this parameter is discouraged, as it is no longer in use.")
    @JsonProperty(value="appendSignature")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getAppendSignature() {
        return this.appendSignature;
    }

    @JsonProperty(value="appendSignature")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAppendSignature(Boolean appendSignature) {
        this.appendSignature = appendSignature;
    }

    public OperationAddSignature certificationLevel(CertificationLevelEnum certificationLevel) {
        this.certificationLevel = certificationLevel;
        return this;
    }

    @Schema(name="This parameter defines the level of the signature.  *   none = Sign, but do not certify, the document, i.e., additional signatures and changes will be allowed. *   noChanges = Certify the document and do not allow any additional changes anymore. *   formFillingAndSignatures = Certify the document, but allow for fields to be filled out. *   formFillingAndSignaturesAndAnnotations = Certify the document, but allow for fields to be filled out and annotations to be added.")
    @JsonProperty(value="certificationLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public CertificationLevelEnum getCertificationLevel() {
        return this.certificationLevel;
    }

    @JsonProperty(value="certificationLevel")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCertificationLevel(CertificationLevelEnum certificationLevel) {
        this.certificationLevel = certificationLevel;
    }

    public OperationAddSignature contact(String contact) {
        this.contact = contact;
        return this;
    }

    @Schema(name="Specifies the name of the person signing the document.")
    @JsonProperty(value="contact")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getContact() {
        return this.contact;
    }

    @JsonProperty(value="contact")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContact(String contact) {
        this.contact = contact;
    }

    public OperationAddSignature fieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    @Schema(name="Defines the name of the field (in the document) in which the signature will be saved. If a field name that is not unique is declared, then a unique name will be automatically created.")
    @JsonProperty(value="fieldName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getFieldName() {
        return this.fieldName;
    }

    @JsonProperty(value="fieldName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public OperationAddSignature keyName(String keyName) {
        this.keyName = keyName;
        return this;
    }

    @Schema(name="Defines the name of the key (alias) that is to be used to sign the document. This option overwrites the server's configuration setting. Additional information can be found in the \"Keystore\" chapter.")
    @JsonProperty(value="keyName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getKeyName() {
        return this.keyName;
    }

    @JsonProperty(value="keyName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public OperationAddSignature keyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
        return this;
    }

    @Schema(name="Used to define the password required in order to access the private key with \"keyName.\" This option overwrites the server's configuration setting. Additional information can be found in the \"Keystore\" chapter.")
    @JsonProperty(value="keyPassword")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getKeyPassword() {
        return this.keyPassword;
    }

    @JsonProperty(value="keyPassword")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public OperationAddSignature location(String location) {
        this.location = location;
        return this;
    }

    @Schema(name="Specifies the location of the signature.")
    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getLocation() {
        return this.location;
    }

    @JsonProperty(value="location")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocation(String location) {
        this.location = location;
    }

    public OperationAddSignature reason(String reason) {
        this.reason = reason;
        return this;
    }

    @Schema(name="Specifies the reason why the document is being signed.")
    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getReason() {
        return this.reason;
    }

    @JsonProperty(value="reason")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReason(String reason) {
        this.reason = reason;
    }

    public OperationAddSignature signer(OperationSignerAdd signer) {
        this.signer = signer;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="signer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationSignerAdd getSigner() {
        return this.signer;
    }

    @JsonProperty(value="signer")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSigner(OperationSignerAdd signer) {
        this.signer = signer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationAddSignature operationAddSignature = (OperationAddSignature)o;
        return Objects.equals(this.appearance, operationAddSignature.appearance) && Objects.equals(this.appendSignature, operationAddSignature.appendSignature) && Objects.equals((Object)this.certificationLevel, (Object)operationAddSignature.certificationLevel) && Objects.equals(this.contact, operationAddSignature.contact) && Objects.equals(this.fieldName, operationAddSignature.fieldName) && Objects.equals(this.keyName, operationAddSignature.keyName) && Objects.equals(this.keyPassword, operationAddSignature.keyPassword) && Objects.equals(this.location, operationAddSignature.location) && Objects.equals(this.reason, operationAddSignature.reason) && Objects.equals(this.signer, operationAddSignature.signer);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.appearance, this.appendSignature, this.certificationLevel, this.contact, this.fieldName, this.keyName, this.keyPassword, this.location, this.reason, this.signer});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationAddSignature {\n");
        sb.append("    appearance: ").append(this.toIndentedString(this.appearance)).append("\n");
        sb.append("    appendSignature: ").append(this.toIndentedString(this.appendSignature)).append("\n");
        sb.append("    certificationLevel: ").append(this.toIndentedString((Object)this.certificationLevel)).append("\n");
        sb.append("    contact: ").append(this.toIndentedString(this.contact)).append("\n");
        sb.append("    fieldName: ").append(this.toIndentedString(this.fieldName)).append("\n");
        sb.append("    keyName: ").append(this.toIndentedString(this.keyName)).append("\n");
        sb.append("    keyPassword: ").append(this.toIndentedString(this.keyPassword)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    reason: ").append(this.toIndentedString(this.reason)).append("\n");
        sb.append("    signer: ").append(this.toIndentedString(this.signer)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CertificationLevelEnum {
        NONE("none"),
        NOCHANGES("noChanges"),
        FORMFILLINGANDSIGNATURES("formFillingAndSignatures"),
        FORMFILLINGANDSIGNATURESANDANNOTATIONS("formFillingAndSignaturesAndAnnotations");

        private String value;

        private CertificationLevelEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CertificationLevelEnum fromValue(String value) {
            for (CertificationLevelEnum b : CertificationLevelEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

