/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationRectangle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Schema(description="This section is used to control the recognition process and configure settings that apply only to specific barcode types.")
@JsonPropertyOrder(value={"allowedLengths", "barcode39CheckDigit", "charset", "codabarStartEndDigits", "formats", "gs1", "pages", "pureBarcode", "resolution", "scanArea", "tryHarder", "upcEanExtensions"})
@JsonTypeName(value="Operation_BarcodeSelection")
public class OperationBarcodeSelection {
    public static final String JSON_PROPERTY_ALLOWED_LENGTHS = "allowedLengths";
    private String allowedLengths = "";
    public static final String JSON_PROPERTY_BARCODE39_CHECK_DIGIT = "barcode39CheckDigit";
    private Boolean barcode39CheckDigit = false;
    public static final String JSON_PROPERTY_CHARSET = "charset";
    private String charset = "utf-8";
    public static final String JSON_PROPERTY_CODABAR_START_END_DIGITS = "codabarStartEndDigits";
    private Boolean codabarStartEndDigits = false;
    public static final String JSON_PROPERTY_FORMATS = "formats";
    private String formats = "";
    public static final String JSON_PROPERTY_GS1 = "gs1";
    private Boolean gs1 = false;
    public static final String JSON_PROPERTY_PAGES = "pages";
    private String pages = "";
    public static final String JSON_PROPERTY_PURE_BARCODE = "pureBarcode";
    private Boolean pureBarcode = false;
    public static final String JSON_PROPERTY_RESOLUTION = "resolution";
    private Integer resolution = 200;
    public static final String JSON_PROPERTY_SCAN_AREA = "scanArea";
    private OperationRectangle scanArea;
    public static final String JSON_PROPERTY_TRY_HARDER = "tryHarder";
    private Boolean tryHarder = true;
    public static final String JSON_PROPERTY_UPC_EAN_EXTENSIONS = "upcEanExtensions";
    private String upcEanExtensions = "";

    public OperationBarcodeSelection allowedLengths(String allowedLengths) {
        this.allowedLengths = allowedLengths;
        return this;
    }

    @Schema(name="If this value is set, it will limit the allowed lengths for encoded values. In other words, barcodes with a length that is not listed will be ignored. (Example: \"13,8,25\")")
    @JsonProperty(value="allowedLengths")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getAllowedLengths() {
        return this.allowedLengths;
    }

    @JsonProperty(value="allowedLengths")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAllowedLengths(String allowedLengths) {
        this.allowedLengths = allowedLengths;
    }

    public OperationBarcodeSelection barcode39CheckDigit(Boolean barcode39CheckDigit) {
        this.barcode39CheckDigit = barcode39CheckDigit;
        return this;
    }

    @Schema(name="If this value is set to \"true\", the system will assume that all recognized Code 39 barcodes contain a correct check digit.")
    @JsonProperty(value="barcode39CheckDigit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getBarcode39CheckDigit() {
        return this.barcode39CheckDigit;
    }

    @JsonProperty(value="barcode39CheckDigit")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBarcode39CheckDigit(Boolean barcode39CheckDigit) {
        this.barcode39CheckDigit = barcode39CheckDigit;
    }

    public OperationBarcodeSelection charset(String charset) {
        this.charset = charset;
        return this;
    }

    @Schema(name="Used to specify the character set in which the barcode contents are stored.")
    @JsonProperty(value="charset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getCharset() {
        return this.charset;
    }

    @JsonProperty(value="charset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCharset(String charset) {
        this.charset = charset;
    }

    public OperationBarcodeSelection codabarStartEndDigits(Boolean codabarStartEndDigits) {
        this.codabarStartEndDigits = codabarStartEndDigits;
        return this;
    }

    @Schema(name="If this value is set to \"true\", the start and stop symbols of recognized Codabar barcodes will be read instead of removed during recognition.")
    @JsonProperty(value="codabarStartEndDigits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getCodabarStartEndDigits() {
        return this.codabarStartEndDigits;
    }

    @JsonProperty(value="codabarStartEndDigits")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCodabarStartEndDigits(Boolean codabarStartEndDigits) {
        this.codabarStartEndDigits = codabarStartEndDigits;
    }

    public OperationBarcodeSelection formats(String formats) {
        this.formats = formats;
        return this;
    }

    @Schema(required=true, name="Used to define the list of barcodes (comma-separated) that should be searched for. There must be at least one barcode format here; otherwise, no search will be run. The names are the same as those used in `<add>`, i.e., the following are the barcode names available:  *   qrcode *   aztec *   codabar *   code128 *   code39 *   datamatrix *   ean13 *   ean8 *   itf *   pdf417 *   upca")
    @JsonProperty(value="formats")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public String getFormats() {
        return this.formats;
    }

    @JsonProperty(value="formats")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFormats(String formats) {
        this.formats = formats;
    }

    public OperationBarcodeSelection gs1(Boolean gs1) {
        this.gs1 = gs1;
        return this;
    }

    @Schema(name="If this value is set to \"true\", the system will assume that all recognized barcodes are GS1-compliant barcodes, and the way all processes behave and work will be adjusted accordingly (for instance, the way in which the FNC1 character is handled for Code 128)")
    @JsonProperty(value="gs1")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getGs1() {
        return this.gs1;
    }

    @JsonProperty(value="gs1")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGs1(Boolean gs1) {
        this.gs1 = gs1;
    }

    public OperationBarcodeSelection pages(String pages) {
        this.pages = pages;
        return this;
    }

    @Schema(name="The page range within which barcodes should be scanned. Individual pages or a range of pages can be defined here. If the text is empty, the entire file will be exported (e.g.: \"1-10\" or \"1,2,5-10\")")
    @JsonProperty(value="pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getPages() {
        return this.pages;
    }

    @JsonProperty(value="pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPages(String pages) {
        this.pages = pages;
    }

    public OperationBarcodeSelection pureBarcode(Boolean pureBarcode) {
        this.pureBarcode = pureBarcode;
        return this;
    }

    @Schema(name="If this value is set to \"true\", the system will assume that the source document being scanned (limited by `<scanArea>`) does not contain any elements other than the barcode. This option can speed up the recognition process significantly. If, however, this option is enabled and there are elements other than a barcode, recognition may fail completely.")
    @JsonProperty(value="pureBarcode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getPureBarcode() {
        return this.pureBarcode;
    }

    @JsonProperty(value="pureBarcode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPureBarcode(Boolean pureBarcode) {
        this.pureBarcode = pureBarcode;
    }

    public OperationBarcodeSelection resolution(Integer resolution) {
        this.resolution = resolution;
        return this;
    }

    @Schema(name="Used to select the resolution for the recognition operation. Depending on the barcode's format and quality, higher or lower values may yield better results (in any case, higher values will slow down processing).")
    @JsonProperty(value="resolution")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getResolution() {
        return this.resolution;
    }

    @JsonProperty(value="resolution")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setResolution(Integer resolution) {
        this.resolution = resolution;
    }

    public OperationBarcodeSelection scanArea(OperationRectangle scanArea) {
        this.scanArea = scanArea;
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="scanArea")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public OperationRectangle getScanArea() {
        return this.scanArea;
    }

    @JsonProperty(value="scanArea")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setScanArea(OperationRectangle scanArea) {
        this.scanArea = scanArea;
    }

    public OperationBarcodeSelection tryHarder(Boolean tryHarder) {
        this.tryHarder = tryHarder;
        return this;
    }

    @Schema(name="If this value is set to \"true\", more computing time will be invested in order to guarantee successful recognition. For example, the system will also scan for barcodes along the vertical axis.")
    @JsonProperty(value="tryHarder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getTryHarder() {
        return this.tryHarder;
    }

    @JsonProperty(value="tryHarder")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTryHarder(Boolean tryHarder) {
        this.tryHarder = tryHarder;
    }

    public OperationBarcodeSelection upcEanExtensions(String upcEanExtensions) {
        this.upcEanExtensions = upcEanExtensions;
        return this;
    }

    @Schema(name="If this value is set, it will limit the allowed lengths for encoded EAN and UPC Extensions. In other words, barcodes with an Extension length that is not listed will be ignored. (Example: \"2,5\")")
    @JsonProperty(value="upcEanExtensions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getUpcEanExtensions() {
        return this.upcEanExtensions;
    }

    @JsonProperty(value="upcEanExtensions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpcEanExtensions(String upcEanExtensions) {
        this.upcEanExtensions = upcEanExtensions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationBarcodeSelection operationBarcodeSelection = (OperationBarcodeSelection)o;
        return Objects.equals(this.allowedLengths, operationBarcodeSelection.allowedLengths) && Objects.equals(this.barcode39CheckDigit, operationBarcodeSelection.barcode39CheckDigit) && Objects.equals(this.charset, operationBarcodeSelection.charset) && Objects.equals(this.codabarStartEndDigits, operationBarcodeSelection.codabarStartEndDigits) && Objects.equals(this.formats, operationBarcodeSelection.formats) && Objects.equals(this.gs1, operationBarcodeSelection.gs1) && Objects.equals(this.pages, operationBarcodeSelection.pages) && Objects.equals(this.pureBarcode, operationBarcodeSelection.pureBarcode) && Objects.equals(this.resolution, operationBarcodeSelection.resolution) && Objects.equals(this.scanArea, operationBarcodeSelection.scanArea) && Objects.equals(this.tryHarder, operationBarcodeSelection.tryHarder) && Objects.equals(this.upcEanExtensions, operationBarcodeSelection.upcEanExtensions);
    }

    public int hashCode() {
        return Objects.hash(this.allowedLengths, this.barcode39CheckDigit, this.charset, this.codabarStartEndDigits, this.formats, this.gs1, this.pages, this.pureBarcode, this.resolution, this.scanArea, this.tryHarder, this.upcEanExtensions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationBarcodeSelection {\n");
        sb.append("    allowedLengths: ").append(this.toIndentedString(this.allowedLengths)).append("\n");
        sb.append("    barcode39CheckDigit: ").append(this.toIndentedString(this.barcode39CheckDigit)).append("\n");
        sb.append("    charset: ").append(this.toIndentedString(this.charset)).append("\n");
        sb.append("    codabarStartEndDigits: ").append(this.toIndentedString(this.codabarStartEndDigits)).append("\n");
        sb.append("    formats: ").append(this.toIndentedString(this.formats)).append("\n");
        sb.append("    gs1: ").append(this.toIndentedString(this.gs1)).append("\n");
        sb.append("    pages: ").append(this.toIndentedString(this.pages)).append("\n");
        sb.append("    pureBarcode: ").append(this.toIndentedString(this.pureBarcode)).append("\n");
        sb.append("    resolution: ").append(this.toIndentedString(this.resolution)).append("\n");
        sb.append("    scanArea: ").append(this.toIndentedString(this.scanArea)).append("\n");
        sb.append("    tryHarder: ").append(this.toIndentedString(this.tryHarder)).append("\n");
        sb.append("    upcEanExtensions: ").append(this.toIndentedString(this.upcEanExtensions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

