/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="If this element is set, all redact annotations placed in the document will be converted into actual content redactions. Content obscured by such an annotation will be irretrievably removed from the page content.")
@JsonPropertyOrder(value={"collisionRatio", "redactAnnotations", "redactImages", "redactPaths", "redactTexts"})
@JsonTypeName(value="Operation_Blacken")
public class OperationBlacken {
    public static final String JSON_PROPERTY_COLLISION_RATIO = "collisionRatio";
    private Integer collisionRatio = 30;
    public static final String JSON_PROPERTY_REDACT_ANNOTATIONS = "redactAnnotations";
    private Boolean redactAnnotations = true;
    public static final String JSON_PROPERTY_REDACT_IMAGES = "redactImages";
    private Boolean redactImages = true;
    public static final String JSON_PROPERTY_REDACT_PATHS = "redactPaths";
    private Boolean redactPaths = true;
    public static final String JSON_PROPERTY_REDACT_TEXTS = "redactTexts";
    private Boolean redactTexts = true;

    public OperationBlacken collisionRatio(Integer collisionRatio) {
        this.collisionRatio = collisionRatio;
        return this;
    }

    @Schema(name="Specifies a percentage value by which a letter must be obscured at least to be considered blackened and thus removed.")
    @JsonProperty(value="collisionRatio")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getCollisionRatio() {
        return this.collisionRatio;
    }

    @JsonProperty(value="collisionRatio")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCollisionRatio(Integer collisionRatio) {
        this.collisionRatio = collisionRatio;
    }

    public OperationBlacken redactAnnotations(Boolean redactAnnotations) {
        this.redactAnnotations = redactAnnotations;
        return this;
    }

    @Schema(name="If this value is set to \"true\", all blackened annotations will be removed. Annotations are removed completely even if they are only truncated.")
    @JsonProperty(value="redactAnnotations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getRedactAnnotations() {
        return this.redactAnnotations;
    }

    @JsonProperty(value="redactAnnotations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRedactAnnotations(Boolean redactAnnotations) {
        this.redactAnnotations = redactAnnotations;
    }

    public OperationBlacken redactImages(Boolean redactImages) {
        this.redactImages = redactImages;
        return this;
    }

    @Schema(name="If this value is set to true, all blackened image data will be removed. For images, the entire image is not removed, but the obscured area is replaced by the redaction.")
    @JsonProperty(value="redactImages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getRedactImages() {
        return this.redactImages;
    }

    @JsonProperty(value="redactImages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRedactImages(Boolean redactImages) {
        this.redactImages = redactImages;
    }

    public OperationBlacken redactPaths(Boolean redactPaths) {
        this.redactPaths = redactPaths;
        return this;
    }

    @Schema(name="If this value is set to true, all blackened character paths are removed. The paths are adjusted so that the blackened section is removed from the path construction.")
    @JsonProperty(value="redactPaths")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getRedactPaths() {
        return this.redactPaths;
    }

    @JsonProperty(value="redactPaths")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRedactPaths(Boolean redactPaths) {
        this.redactPaths = redactPaths;
    }

    public OperationBlacken redactTexts(Boolean redactTexts) {
        this.redactTexts = redactTexts;
        return this;
    }

    @Schema(name="If this value is set to \"true\", all texts are blackened letter by letter.")
    @JsonProperty(value="redactTexts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getRedactTexts() {
        return this.redactTexts;
    }

    @JsonProperty(value="redactTexts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRedactTexts(Boolean redactTexts) {
        this.redactTexts = redactTexts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationBlacken operationBlacken = (OperationBlacken)o;
        return Objects.equals(this.collisionRatio, operationBlacken.collisionRatio) && Objects.equals(this.redactAnnotations, operationBlacken.redactAnnotations) && Objects.equals(this.redactImages, operationBlacken.redactImages) && Objects.equals(this.redactPaths, operationBlacken.redactPaths) && Objects.equals(this.redactTexts, operationBlacken.redactTexts);
    }

    public int hashCode() {
        return Objects.hash(this.collisionRatio, this.redactAnnotations, this.redactImages, this.redactPaths, this.redactTexts);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationBlacken {\n");
        sb.append("    collisionRatio: ").append(this.toIndentedString(this.collisionRatio)).append("\n");
        sb.append("    redactAnnotations: ").append(this.toIndentedString(this.redactAnnotations)).append("\n");
        sb.append("    redactImages: ").append(this.toIndentedString(this.redactImages)).append("\n");
        sb.append("    redactPaths: ").append(this.toIndentedString(this.redactPaths)).append("\n");
        sb.append("    redactTexts: ").append(this.toIndentedString(this.redactTexts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

