/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationBackgroundBaseSettings;
import org.jetbrains.annotations.Nullable;

@Schema(description="Adds a solid-color background layer to the document.")
@JsonPropertyOrder(value={"color", "settings"})
@JsonTypeName(value="Operation_ColorBackground")
public class OperationColorBackground {
    public static final String JSON_PROPERTY_COLOR = "color";
    private String color = "#FFFFFF";
    public static final String JSON_PROPERTY_SETTINGS = "settings";
    private OperationBackgroundBaseSettings settings;

    public OperationColorBackground color(String color) {
        this.color = color;
        return this;
    }

    @Schema(name="Used to set the colour for the background layer. The colour needs to be specified as a hexadecimal RGB value with a number sign before it.")
    @JsonProperty(value="color")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getColor() {
        return this.color;
    }

    @JsonProperty(value="color")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setColor(String color) {
        this.color = color;
    }

    public OperationColorBackground settings(OperationBackgroundBaseSettings settings) {
        this.settings = settings;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="settings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationBackgroundBaseSettings getSettings() {
        return this.settings;
    }

    @JsonProperty(value="settings")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSettings(OperationBackgroundBaseSettings settings) {
        this.settings = settings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationColorBackground operationColorBackground = (OperationColorBackground)o;
        return Objects.equals(this.color, operationColorBackground.color) && Objects.equals(this.settings, operationColorBackground.settings);
    }

    public int hashCode() {
        return Objects.hash(this.color, this.settings);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationColorBackground {\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("    settings: ").append(this.toIndentedString(this.settings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

