/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationTemplateData;
import org.jetbrains.annotations.Nullable;

@Schema(description="These settings are only used for HTML (e.g. websites) and HTML-based documents (e.g. e-mails).")
@JsonPropertyOrder(value={"adjustFonts", "baseURL", "downloadImages", "templateData", "useAsTemplate", "useBackground"})
@JsonTypeName(value="Operation_ConverterHtml")
public class OperationConverterHtml {
    public static final String JSON_PROPERTY_ADJUST_FONTS = "adjustFonts";
    private Boolean adjustFonts = false;
    public static final String JSON_PROPERTY_BASE_U_R_L = "baseURL";
    private String baseURL = "";
    public static final String JSON_PROPERTY_DOWNLOAD_IMAGES = "downloadImages";
    private Boolean downloadImages = false;
    public static final String JSON_PROPERTY_TEMPLATE_DATA = "templateData";
    private OperationTemplateData templateData;
    public static final String JSON_PROPERTY_USE_AS_TEMPLATE = "useAsTemplate";
    private Boolean useAsTemplate = false;
    public static final String JSON_PROPERTY_USE_BACKGROUND = "useBackground";
    private Boolean useBackground = true;

    public OperationConverterHtml adjustFonts(Boolean adjustFonts) {
        this.adjustFonts = adjustFonts;
        return this;
    }

    @Schema(name="If \"true\", then the font specifications \"Arial\", \"Helvetica\" and \"Sans-Serif\" in HTML documents and e-mails (which are based on HTML) are automatically replaced by the \"Arial Unicode MS\" font. The improves the appearance of the typeface in the PDF result.")
    @JsonProperty(value="adjustFonts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getAdjustFonts() {
        return this.adjustFonts;
    }

    @JsonProperty(value="adjustFonts")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAdjustFonts(Boolean adjustFonts) {
        this.adjustFonts = adjustFonts;
    }

    public OperationConverterHtml baseURL(String baseURL) {
        this.baseURL = baseURL;
        return this;
    }

    @Schema(name="Used to define the URL used as a basis for all URLs in the HTML document that are not defined as absolute URLs.")
    @JsonProperty(value="baseURL")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getBaseURL() {
        return this.baseURL;
    }

    @JsonProperty(value="baseURL")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    public OperationConverterHtml downloadImages(Boolean downloadImages) {
        this.downloadImages = downloadImages;
        return this;
    }

    @Schema(name="If \"true\", then the images of an e-mail or an HTML document are downloaded automatically. This option could slow down the conversion considerably if there are many images contained or if, for example, e-mail documents are converted in which the images can no longer be invoked.")
    @JsonProperty(value="downloadImages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getDownloadImages() {
        return this.downloadImages;
    }

    @JsonProperty(value="downloadImages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDownloadImages(Boolean downloadImages) {
        this.downloadImages = downloadImages;
    }

    public OperationConverterHtml templateData(OperationTemplateData templateData) {
        this.templateData = templateData;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="templateData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationTemplateData getTemplateData() {
        return this.templateData;
    }

    @JsonProperty(value="templateData")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTemplateData(OperationTemplateData templateData) {
        this.templateData = templateData;
    }

    public OperationConverterHtml useAsTemplate(Boolean useAsTemplate) {
        this.useAsTemplate = useAsTemplate;
        return this;
    }

    @Schema(name="If \"true\", the HTML document will be interpreted as a template, i.e., the system will search for variables in the HTML and replace them with the data passed in \"templateData\". The document will not be converted to HTML format until after this step is completed. This means that by using the HTML document as a template together with passed data, you can obtain a dynamically generated PDF document.")
    @JsonProperty(value="useAsTemplate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getUseAsTemplate() {
        return this.useAsTemplate;
    }

    @JsonProperty(value="useAsTemplate")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUseAsTemplate(Boolean useAsTemplate) {
        this.useAsTemplate = useAsTemplate;
    }

    public OperationConverterHtml useBackground(Boolean useBackground) {
        this.useBackground = useBackground;
        return this;
    }

    @Schema(name="If \"true\", the background defined in the HTML document will be output in the PDF document as well. If \"false\", the background will be hidden.")
    @JsonProperty(value="useBackground")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getUseBackground() {
        return this.useBackground;
    }

    @JsonProperty(value="useBackground")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUseBackground(Boolean useBackground) {
        this.useBackground = useBackground;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationConverterHtml operationConverterHtml = (OperationConverterHtml)o;
        return Objects.equals(this.adjustFonts, operationConverterHtml.adjustFonts) && Objects.equals(this.baseURL, operationConverterHtml.baseURL) && Objects.equals(this.downloadImages, operationConverterHtml.downloadImages) && Objects.equals(this.templateData, operationConverterHtml.templateData) && Objects.equals(this.useAsTemplate, operationConverterHtml.useAsTemplate) && Objects.equals(this.useBackground, operationConverterHtml.useBackground);
    }

    public int hashCode() {
        return Objects.hash(this.adjustFonts, this.baseURL, this.downloadImages, this.templateData, this.useAsTemplate, this.useBackground);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationConverterHtml {\n");
        sb.append("    adjustFonts: ").append(this.toIndentedString(this.adjustFonts)).append("\n");
        sb.append("    baseURL: ").append(this.toIndentedString(this.baseURL)).append("\n");
        sb.append("    downloadImages: ").append(this.toIndentedString(this.downloadImages)).append("\n");
        sb.append("    templateData: ").append(this.toIndentedString(this.templateData)).append("\n");
        sb.append("    useAsTemplate: ").append(this.toIndentedString(this.useAsTemplate)).append("\n");
        sb.append("    useBackground: ").append(this.toIndentedString(this.useBackground)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

