/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationXRechnung;
import net.webpdf.wsclient.openapi.OperationXslTransformation;
import org.jetbrains.annotations.Nullable;

@Schema(description="This element defines a set of transformations to be applied to the document before further converter operations are performed. For example, an XSLT transformation could be applied to an XML document to transform it to HTML before converting that HTML content to a PDF document. This element currently recognizes two forms of transformations:  *   XSLT transformation - a generic transformation to any output format. Optimally, the transformation creates a document format (such as HTML) that the downstream conversion can convert to a PDF document. The generic transformation can contain an arbitrary number of XSLT elements, defined as `<resources>`, each of which is successively applied to the result of the preceding transformation.*   XInvoice transformation - XML data in XInvoice format (CII or UBL) transformed into a visual image by means of transformation.  Normally, no further specification is necessary here, because a standard layout for the visual image of an X-invoice is stored on the server. However, if a different layout is to be used, this must be specified via the `<visualization>` element. The file used there must be an XLST stylesheet, which creates the XInvoice data as HTML output.")
@JsonPropertyOrder(value={"xRechnung", "xslTransformation"})
@JsonTypeName(value="Operation_ConverterTransform")
public class OperationConverterTransform {
    public static final String JSON_PROPERTY_X_RECHNUNG = "xRechnung";
    private OperationXRechnung xRechnung;
    public static final String JSON_PROPERTY_XSL_TRANSFORMATION = "xslTransformation";
    private OperationXslTransformation xslTransformation;

    public OperationConverterTransform xRechnung(OperationXRechnung xRechnung) {
        this.xRechnung = xRechnung;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="xRechnung")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationXRechnung getxRechnung() {
        return this.xRechnung;
    }

    @JsonProperty(value="xRechnung")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setxRechnung(OperationXRechnung xRechnung) {
        this.xRechnung = xRechnung;
    }

    public OperationConverterTransform xslTransformation(OperationXslTransformation xslTransformation) {
        this.xslTransformation = xslTransformation;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="xslTransformation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationXslTransformation getXslTransformation() {
        return this.xslTransformation;
    }

    @JsonProperty(value="xslTransformation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setXslTransformation(OperationXslTransformation xslTransformation) {
        this.xslTransformation = xslTransformation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationConverterTransform operationConverterTransform = (OperationConverterTransform)o;
        return Objects.equals(this.xRechnung, operationConverterTransform.xRechnung) && Objects.equals(this.xslTransformation, operationConverterTransform.xslTransformation);
    }

    public int hashCode() {
        return Objects.hash(this.xRechnung, this.xslTransformation);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationConverterTransform {\n");
        sb.append("    xRechnung: ").append(this.toIndentedString(this.xRechnung)).append("\n");
        sb.append("    xslTransformation: ").append(this.toIndentedString(this.xslTransformation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

