/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationRecipient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Schema(description="These parameters can be used to set the asymmetric encryption of a PDF document.")
@JsonPropertyOrder(value={"contentEncryption", "encryptionKey", "recipient"})
@JsonTypeName(value="Operation_EncryptCertificate")
public class OperationEncryptCertificate {
    public static final String JSON_PROPERTY_CONTENT_ENCRYPTION = "contentEncryption";
    private ContentEncryptionEnum contentEncryption = ContentEncryptionEnum.ENCRYPTEVERYTHING;
    public static final String JSON_PROPERTY_ENCRYPTION_KEY = "encryptionKey";
    private EncryptionKeyEnum encryptionKey = EncryptionKeyEnum.RC4_128;
    public static final String JSON_PROPERTY_RECIPIENT = "recipient";
    private List<OperationRecipient> recipient = new ArrayList<OperationRecipient>();

    public OperationEncryptCertificate contentEncryption(ContentEncryptionEnum contentEncryption) {
        this.contentEncryption = contentEncryption;
        return this;
    }

    @Schema(name="Specifies whether certain contents should be treated differently than others during encryption.  *   encryptEverything = All contents of the document are encrypted without distinction (if provided by the standard). *   exposeMetadata = The document's metadata is left unencrypted to make it discoverable by processing programs. (Has an effect only for 128 bit and 256 bit AES).")
    @JsonProperty(value="contentEncryption")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public ContentEncryptionEnum getContentEncryption() {
        return this.contentEncryption;
    }

    @JsonProperty(value="contentEncryption")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContentEncryption(ContentEncryptionEnum contentEncryption) {
        this.contentEncryption = contentEncryption;
    }

    public OperationEncryptCertificate encryptionKey(EncryptionKeyEnum encryptionKey) {
        this.encryptionKey = encryptionKey;
        return this;
    }

    @Schema(name="Sets the encryption level for the document.  *   RC4\\_40 = 40-bit RC4 *   RC4\\_128 = 128-bit RC4 *   AES\\_128 = 128-bit AES *   AES\\_256 = 256-bit AES  **Important:** Please note that the option \"256-bit AES\" only works if the \"Java Cryptography Extension (JCE)\" has been enabled with \"Unlimited Strength\" in the JVM. You can obtain the modified \"Policy Files\" (along with instructions for installation) from the Oracle website: Java Cryptography Extension (JCE) Unlimited Strength Jurisdiction Policy Files 7 Download: http://www.oracle.com/technetwork/java/javase/downloads/jce-7-download-432124.html")
    @JsonProperty(value="encryptionKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public EncryptionKeyEnum getEncryptionKey() {
        return this.encryptionKey;
    }

    @JsonProperty(value="encryptionKey")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEncryptionKey(EncryptionKeyEnum encryptionKey) {
        this.encryptionKey = encryptionKey;
    }

    public OperationEncryptCertificate recipient(List<OperationRecipient> recipient) {
        this.recipient = recipient;
        return this;
    }

    public OperationEncryptCertificate addRecipientItem(OperationRecipient recipientItem) {
        this.recipient.add(recipientItem);
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="recipient")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public List<OperationRecipient> getRecipient() {
        return this.recipient;
    }

    @JsonProperty(value="recipient")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRecipient(List<OperationRecipient> recipient) {
        this.recipient = recipient;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationEncryptCertificate operationEncryptCertificate = (OperationEncryptCertificate)o;
        return Objects.equals((Object)this.contentEncryption, (Object)operationEncryptCertificate.contentEncryption) && Objects.equals((Object)this.encryptionKey, (Object)operationEncryptCertificate.encryptionKey) && Objects.equals(this.recipient, operationEncryptCertificate.recipient);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.contentEncryption, this.encryptionKey, this.recipient});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationEncryptCertificate {\n");
        sb.append("    contentEncryption: ").append(this.toIndentedString((Object)this.contentEncryption)).append("\n");
        sb.append("    encryptionKey: ").append(this.toIndentedString((Object)this.encryptionKey)).append("\n");
        sb.append("    recipient: ").append(this.toIndentedString(this.recipient)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum EncryptionKeyEnum {
        RC4_40("RC4_40"),
        RC4_128("RC4_128"),
        AES_128("AES_128"),
        AES_256("AES_256");

        private String value;

        private EncryptionKeyEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static EncryptionKeyEnum fromValue(String value) {
            for (EncryptionKeyEnum b : EncryptionKeyEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ContentEncryptionEnum {
        ENCRYPTEVERYTHING("encryptEverything"),
        EXPOSEMETADATA("exposeMetadata");

        private String value;

        private ContentEncryptionEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ContentEncryptionEnum fromValue(String value) {
            for (ContentEncryptionEnum b : ContentEncryptionEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

