/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Extract general and structure information about the PDF document  Generates an XML or JSON file that will be returned as a result when the web service is called. This file will contain information about the PDF document such as the corresponding security settings, PDF properties, or PDF/A status.")
@JsonPropertyOrder(value={"fileFormat", "pages"})
@JsonTypeName(value="Operation_ExtractionInfo")
public class OperationExtractionInfo {
    public static final String JSON_PROPERTY_FILE_FORMAT = "fileFormat";
    private FileFormatEnum fileFormat = FileFormatEnum.XML;
    public static final String JSON_PROPERTY_PAGES = "pages";
    private String pages = "";

    public OperationExtractionInfo fileFormat(FileFormatEnum fileFormat) {
        this.fileFormat = fileFormat;
        return this;
    }

    @Schema(name="Used to define the output format for the PDF document text contents being extracted.  *   text = Text document *   xml = XML document *   json = JSON data structure")
    @JsonProperty(value="fileFormat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public FileFormatEnum getFileFormat() {
        return this.fileFormat;
    }

    @JsonProperty(value="fileFormat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFileFormat(FileFormatEnum fileFormat) {
        this.fileFormat = fileFormat;
    }

    public OperationExtractionInfo pages(String pages) {
        this.pages = pages;
        return this;
    }

    @Schema(name="Used to define which page(s) should be used for the extraction mode. The page number can be either an individual page, a page range, or a list (separated with commas) (e.g., \"1,5-6,9\"). A blank value or \"\\*\" selects all pages of the PDF document.")
    @JsonProperty(value="pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getPages() {
        return this.pages;
    }

    @JsonProperty(value="pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPages(String pages) {
        this.pages = pages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationExtractionInfo operationExtractionInfo = (OperationExtractionInfo)o;
        return Objects.equals((Object)this.fileFormat, (Object)operationExtractionInfo.fileFormat) && Objects.equals(this.pages, operationExtractionInfo.pages);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fileFormat, this.pages});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationExtractionInfo {\n");
        sb.append("    fileFormat: ").append(this.toIndentedString((Object)this.fileFormat)).append("\n");
        sb.append("    pages: ").append(this.toIndentedString(this.pages)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum FileFormatEnum {
        TEXT("text"),
        XML("xml"),
        JSON("json"),
        ZIP("zip");

        private String value;

        private FileFormatEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FileFormatEnum fromValue(String value) {
            for (FileFormatEnum b : FileFormatEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

