/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Defines a target GIF image format.")
@JsonPropertyOrder(value={"dpi", "height", "metrics", "width"})
@JsonTypeName(value="Operation_Gif")
public class OperationGif {
    public static final String JSON_PROPERTY_DPI = "dpi";
    private Integer dpi = 72;
    public static final String JSON_PROPERTY_HEIGHT = "height";
    private Integer height = 0;
    public static final String JSON_PROPERTY_METRICS = "metrics";
    private MetricsEnum metrics = MetricsEnum.MM;
    public static final String JSON_PROPERTY_WIDTH = "width";
    private Integer width = 0;

    public OperationGif dpi(Integer dpi) {
        this.dpi = dpi;
        return this;
    }

    @Schema(name="This parameter is used to define the image's DPI resolution. The larger the value, the larger the image's x, y resolution. In addition, the larger the DPI resolution, the larger the size of the image file.")
    @JsonProperty(value="dpi")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getDpi() {
        return this.dpi;
    }

    @JsonProperty(value="dpi")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDpi(Integer dpi) {
        this.dpi = dpi;
    }

    public OperationGif height(Integer height) {
        this.height = height;
        return this;
    }

    @Schema(name="Used to limit the maximum height of the exported image. 0 = No restriction")
    @JsonProperty(value="height")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getHeight() {
        return this.height;
    }

    @JsonProperty(value="height")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHeight(Integer height) {
        this.height = height;
    }

    public OperationGif metrics(MetricsEnum metrics) {
        this.metrics = metrics;
        return this;
    }

    @Schema(name="Unit for the X-axis/Y-axis position and signature field height and width arguments:  *   pt = Points(1/72 inch) *   pc = Picas(12 points) *   px = Pixels(1/96 inch) *   mm = Millimeters *   in = Inches")
    @JsonProperty(value="metrics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public MetricsEnum getMetrics() {
        return this.metrics;
    }

    @JsonProperty(value="metrics")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMetrics(MetricsEnum metrics) {
        this.metrics = metrics;
    }

    public OperationGif width(Integer width) {
        this.width = width;
        return this;
    }

    @Schema(name="Used to limit the maximum width of the exported image. 0 = No restriction")
    @JsonProperty(value="width")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getWidth() {
        return this.width;
    }

    @JsonProperty(value="width")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWidth(Integer width) {
        this.width = width;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationGif operationGif = (OperationGif)o;
        return Objects.equals(this.dpi, operationGif.dpi) && Objects.equals(this.height, operationGif.height) && Objects.equals((Object)this.metrics, (Object)operationGif.metrics) && Objects.equals(this.width, operationGif.width);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dpi, this.height, this.metrics, this.width});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationGif {\n");
        sb.append("    dpi: ").append(this.toIndentedString(this.dpi)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    metrics: ").append(this.toIndentedString((Object)this.metrics)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum MetricsEnum {
        PT("pt"),
        PC("pc"),
        PX("px"),
        MM("mm"),
        IN("in");

        private String value;

        private MetricsEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MetricsEnum fromValue(String value) {
            for (MetricsEnum b : MetricsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

