/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Used to define the proxy and the access information if the resource must be fetched through a proxy.")
@JsonPropertyOrder(value={"address", "password", "port", "userName"})
@JsonTypeName(value="Operation_HttpProxy")
public class OperationHttpProxy {
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private String address = "";
    public static final String JSON_PROPERTY_PASSWORD = "password";
    private String password = "";
    public static final String JSON_PROPERTY_PORT = "port";
    private Integer port = 0;
    public static final String JSON_PROPERTY_USER_NAME = "userName";
    private String userName = "";

    public OperationHttpProxy address(String address) {
        this.address = address;
        return this;
    }

    @Schema(name="The address at which the proxy server can be reached.")
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddress(String address) {
        this.address = address;
    }

    public OperationHttpProxy password(String password) {
        this.password = password;
        return this;
    }

    @Schema(name="Password if access to the proxy service requires authentication.")
    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPassword(String password) {
        this.password = password;
    }

    public OperationHttpProxy port(Integer port) {
        this.port = port;
        return this;
    }

    @Schema(name="The port that should be used to access the proxy server.")
    @JsonProperty(value="port")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getPort() {
        return this.port;
    }

    @JsonProperty(value="port")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPort(Integer port) {
        this.port = port;
    }

    public OperationHttpProxy userName(String userName) {
        this.userName = userName;
        return this;
    }

    @Schema(name="Username if access to the proxy service requires authentication.")
    @JsonProperty(value="userName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getUserName() {
        return this.userName;
    }

    @JsonProperty(value="userName")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUserName(String userName) {
        this.userName = userName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationHttpProxy operationHttpProxy = (OperationHttpProxy)o;
        return Objects.equals(this.address, operationHttpProxy.address) && Objects.equals(this.password, operationHttpProxy.password) && Objects.equals(this.port, operationHttpProxy.port) && Objects.equals(this.userName, operationHttpProxy.userName);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.password, this.port, this.userName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationHttpProxy {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("    userName: ").append(this.toIndentedString(this.userName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

