/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationCertificateFileData;
import net.webpdf.wsclient.openapi.OperationPrivateKeyFileData;
import org.jetbrains.annotations.NotNull;

@Schema(description="Allows the private key for decrypting an asymmetrically encrypted document to be handed over and the associated rights holder (recipient) to be selected by means of the certificate assigned to him. The document can only be decrypted if both are present and the private key and certificate both match and are intended for decrypting the document. When encrypting the document, it is possible to define multiple rights holders, but when decrypting the document as configured here, only a single one of these rights holders can be selected for which the decryption is to be performed.")
@JsonPropertyOrder(value={"certificate", "privateKey"})
@JsonTypeName(value="Operation_KeyPair")
public class OperationKeyPair {
    public static final String JSON_PROPERTY_CERTIFICATE = "certificate";
    private OperationCertificateFileData certificate;
    public static final String JSON_PROPERTY_PRIVATE_KEY = "privateKey";
    private OperationPrivateKeyFileData privateKey;

    public OperationKeyPair certificate(OperationCertificateFileData certificate) {
        this.certificate = certificate;
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="certificate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public OperationCertificateFileData getCertificate() {
        return this.certificate;
    }

    @JsonProperty(value="certificate")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCertificate(OperationCertificateFileData certificate) {
        this.certificate = certificate;
    }

    public OperationKeyPair privateKey(OperationPrivateKeyFileData privateKey) {
        this.privateKey = privateKey;
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="privateKey")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public OperationPrivateKeyFileData getPrivateKey() {
        return this.privateKey;
    }

    @JsonProperty(value="privateKey")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPrivateKey(OperationPrivateKeyFileData privateKey) {
        this.privateKey = privateKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationKeyPair operationKeyPair = (OperationKeyPair)o;
        return Objects.equals(this.certificate, operationKeyPair.certificate) && Objects.equals(this.privateKey, operationKeyPair.privateKey);
    }

    public int hashCode() {
        return Objects.hash(this.certificate, this.privateKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationKeyPair {\n");
        sb.append("    certificate: ").append(this.toIndentedString(this.certificate)).append("\n");
        sb.append("    privateKey: ").append(this.toIndentedString(this.privateKey)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

