/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationBorder;
import net.webpdf.wsclient.openapi.OperationPoint;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Schema(description="An annotation that draws a simple line on a page.")
@JsonPropertyOrder(value={"border", "color", "contents", "creator", "end", "hidden", "intents", "invisible", "locked", "name", "opacity", "page", "printable", "rotatable", "start", "subject", "viewable", "writable", "zoomable"})
@JsonTypeName(value="Operation_LineAnnotation")
public class OperationLineAnnotation {
    public static final String JSON_PROPERTY_BORDER = "border";
    private OperationBorder border;
    public static final String JSON_PROPERTY_COLOR = "color";
    private String color = "#4800FF";
    public static final String JSON_PROPERTY_CONTENTS = "contents";
    private String contents = "";
    public static final String JSON_PROPERTY_CREATOR = "creator";
    private String creator = "";
    public static final String JSON_PROPERTY_END = "end";
    private OperationPoint end;
    public static final String JSON_PROPERTY_HIDDEN = "hidden";
    private Boolean hidden = false;
    public static final String JSON_PROPERTY_INTENTS = "intents";
    private String intents = "";
    public static final String JSON_PROPERTY_INVISIBLE = "invisible";
    private Boolean invisible = false;
    public static final String JSON_PROPERTY_LOCKED = "locked";
    private Boolean locked = true;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name = "";
    public static final String JSON_PROPERTY_OPACITY = "opacity";
    private Integer opacity = 100;
    public static final String JSON_PROPERTY_PAGE = "page";
    private Integer page = 1;
    public static final String JSON_PROPERTY_PRINTABLE = "printable";
    private Boolean printable = false;
    public static final String JSON_PROPERTY_ROTATABLE = "rotatable";
    private Boolean rotatable = true;
    public static final String JSON_PROPERTY_START = "start";
    private OperationPoint start;
    public static final String JSON_PROPERTY_SUBJECT = "subject";
    private String subject = "";
    public static final String JSON_PROPERTY_VIEWABLE = "viewable";
    private Boolean viewable = true;
    public static final String JSON_PROPERTY_WRITABLE = "writable";
    private Boolean writable = true;
    public static final String JSON_PROPERTY_ZOOMABLE = "zoomable";
    private Boolean zoomable = true;

    public OperationLineAnnotation border(OperationBorder border) {
        this.border = border;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="border")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationBorder getBorder() {
        return this.border;
    }

    @JsonProperty(value="border")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBorder(OperationBorder border) {
        this.border = border;
    }

    public OperationLineAnnotation color(String color) {
        this.color = color;
        return this;
    }

    @Schema(name="The annotation color will change the main color of visible annotations. The color needs to be specified as a hexadecimal RGB value with a number sign before it.")
    @JsonProperty(value="color")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getColor() {
        return this.color;
    }

    @JsonProperty(value="color")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setColor(String color) {
        this.color = color;
    }

    public OperationLineAnnotation contents(String contents) {
        this.contents = contents;
        return this;
    }

    @Schema(name="This value is used to configure the text content of the annotation, with the way in which it is displayed depending heavily on the specific annotation type (for example, in the case of a text note, this would be the text content of the annotation's popup).")
    @JsonProperty(value="contents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getContents() {
        return this.contents;
    }

    @JsonProperty(value="contents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContents(String contents) {
        this.contents = contents;
    }

    public OperationLineAnnotation creator(String creator) {
        this.creator = creator;
        return this;
    }

    @Schema(name="Used to specify the author of the annotation.")
    @JsonProperty(value="creator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getCreator() {
        return this.creator;
    }

    @JsonProperty(value="creator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreator(String creator) {
        this.creator = creator;
    }

    public OperationLineAnnotation end(OperationPoint end) {
        this.end = end;
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="end")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public OperationPoint getEnd() {
        return this.end;
    }

    @JsonProperty(value="end")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEnd(OperationPoint end) {
        this.end = end;
    }

    public OperationLineAnnotation hidden(Boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    @Schema(name="If this value is set to true, the annotation will not be shown on the page and will not be printed either.")
    @JsonProperty(value="hidden")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getHidden() {
        return this.hidden;
    }

    @JsonProperty(value="hidden")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public OperationLineAnnotation intents(String intents) {
        this.intents = intents;
        return this;
    }

    @Schema(name="Used to set the intention of the annotation.  **Important:** The intention of an annotation can directly influence it's behaviour and may serve different purposes for different annotation types. Only set this directly, if you know it is necessary and possible to do so.")
    @JsonProperty(value="intents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getIntents() {
        return this.intents;
    }

    @JsonProperty(value="intents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIntents(String intents) {
        this.intents = intents;
    }

    public OperationLineAnnotation invisible(Boolean invisible) {
        this.invisible = invisible;
        return this;
    }

    @Schema(name="If this value is set to true, the annotation will be visible on the page only when printed, and provided it is a PDF standard annotation.")
    @JsonProperty(value="invisible")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getInvisible() {
        return this.invisible;
    }

    @JsonProperty(value="invisible")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInvisible(Boolean invisible) {
        this.invisible = invisible;
    }

    public OperationLineAnnotation locked(Boolean locked) {
        this.locked = locked;
        return this;
    }

    @Schema(name="If this value is set to true, the annotation will be locked so that no changes can be made to it.")
    @JsonProperty(value="locked")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getLocked() {
        return this.locked;
    }

    @JsonProperty(value="locked")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    public OperationLineAnnotation name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="Used to specify the name of the annotation.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public OperationLineAnnotation opacity(Integer opacity) {
        this.opacity = opacity;
        return this;
    }

    @Schema(name="This percentage value is used to set the annotation's transparency.")
    @JsonProperty(value="opacity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getOpacity() {
        return this.opacity;
    }

    @JsonProperty(value="opacity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOpacity(Integer opacity) {
        this.opacity = opacity;
    }

    public OperationLineAnnotation page(Integer page) {
        this.page = page;
        return this;
    }

    @Schema(name="Set the number of the page, the annotation shall be placed on.")
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPage(Integer page) {
        this.page = page;
    }

    public OperationLineAnnotation printable(Boolean printable) {
        this.printable = printable;
        return this;
    }

    @Schema(name="If this value is set to true, the annotation will be included when the page is printed out.")
    @JsonProperty(value="printable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getPrintable() {
        return this.printable;
    }

    @JsonProperty(value="printable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrintable(Boolean printable) {
        this.printable = printable;
    }

    public OperationLineAnnotation rotatable(Boolean rotatable) {
        this.rotatable = rotatable;
        return this;
    }

    @Schema(name="If this value is set to true, the annotation shall be rotatable according to the displayed page rotation.")
    @JsonProperty(value="rotatable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getRotatable() {
        return this.rotatable;
    }

    @JsonProperty(value="rotatable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRotatable(Boolean rotatable) {
        this.rotatable = rotatable;
    }

    public OperationLineAnnotation start(OperationPoint start) {
        this.start = start;
        return this;
    }

    @Schema(required=true, name="")
    @JsonProperty(value="start")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public OperationPoint getStart() {
        return this.start;
    }

    @JsonProperty(value="start")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setStart(OperationPoint start) {
        this.start = start;
    }

    public OperationLineAnnotation subject(String subject) {
        this.subject = subject;
        return this;
    }

    @Schema(name="Used to specify the subject of the annotation.")
    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubject(String subject) {
        this.subject = subject;
    }

    public OperationLineAnnotation viewable(Boolean viewable) {
        this.viewable = viewable;
        return this;
    }

    @Schema(name="If this value is set to true, the annotation will be shown on the document's page.")
    @JsonProperty(value="viewable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getViewable() {
        return this.viewable;
    }

    @JsonProperty(value="viewable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setViewable(Boolean viewable) {
        this.viewable = viewable;
    }

    public OperationLineAnnotation writable(Boolean writable) {
        this.writable = writable;
        return this;
    }

    @Schema(name="If this value is set to true, it will be possible to change the annotation's contents later on.")
    @JsonProperty(value="writable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getWritable() {
        return this.writable;
    }

    @JsonProperty(value="writable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWritable(Boolean writable) {
        this.writable = writable;
    }

    public OperationLineAnnotation zoomable(Boolean zoomable) {
        this.zoomable = zoomable;
        return this;
    }

    @Schema(name="If this value is set to true, the annotation will adjust its own zoom factor as required for the page in order to always be clearly readable / recognizable.")
    @JsonProperty(value="zoomable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getZoomable() {
        return this.zoomable;
    }

    @JsonProperty(value="zoomable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setZoomable(Boolean zoomable) {
        this.zoomable = zoomable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationLineAnnotation operationLineAnnotation = (OperationLineAnnotation)o;
        return Objects.equals(this.border, operationLineAnnotation.border) && Objects.equals(this.color, operationLineAnnotation.color) && Objects.equals(this.contents, operationLineAnnotation.contents) && Objects.equals(this.creator, operationLineAnnotation.creator) && Objects.equals(this.end, operationLineAnnotation.end) && Objects.equals(this.hidden, operationLineAnnotation.hidden) && Objects.equals(this.intents, operationLineAnnotation.intents) && Objects.equals(this.invisible, operationLineAnnotation.invisible) && Objects.equals(this.locked, operationLineAnnotation.locked) && Objects.equals(this.name, operationLineAnnotation.name) && Objects.equals(this.opacity, operationLineAnnotation.opacity) && Objects.equals(this.page, operationLineAnnotation.page) && Objects.equals(this.printable, operationLineAnnotation.printable) && Objects.equals(this.rotatable, operationLineAnnotation.rotatable) && Objects.equals(this.start, operationLineAnnotation.start) && Objects.equals(this.subject, operationLineAnnotation.subject) && Objects.equals(this.viewable, operationLineAnnotation.viewable) && Objects.equals(this.writable, operationLineAnnotation.writable) && Objects.equals(this.zoomable, operationLineAnnotation.zoomable);
    }

    public int hashCode() {
        return Objects.hash(this.border, this.color, this.contents, this.creator, this.end, this.hidden, this.intents, this.invisible, this.locked, this.name, this.opacity, this.page, this.printable, this.rotatable, this.start, this.subject, this.viewable, this.writable, this.zoomable);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationLineAnnotation {\n");
        sb.append("    border: ").append(this.toIndentedString(this.border)).append("\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("    contents: ").append(this.toIndentedString(this.contents)).append("\n");
        sb.append("    creator: ").append(this.toIndentedString(this.creator)).append("\n");
        sb.append("    end: ").append(this.toIndentedString(this.end)).append("\n");
        sb.append("    hidden: ").append(this.toIndentedString(this.hidden)).append("\n");
        sb.append("    intents: ").append(this.toIndentedString(this.intents)).append("\n");
        sb.append("    invisible: ").append(this.toIndentedString(this.invisible)).append("\n");
        sb.append("    locked: ").append(this.toIndentedString(this.locked)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    opacity: ").append(this.toIndentedString(this.opacity)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    printable: ").append(this.toIndentedString(this.printable)).append("\n");
        sb.append("    rotatable: ").append(this.toIndentedString(this.rotatable)).append("\n");
        sb.append("    start: ").append(this.toIndentedString(this.start)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    viewable: ").append(this.toIndentedString(this.viewable)).append("\n");
        sb.append("    writable: ").append(this.toIndentedString(this.writable)).append("\n");
        sb.append("    zoomable: ").append(this.toIndentedString(this.zoomable)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

