/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationPositionMarkupAnnotation;
import org.jetbrains.annotations.Nullable;

@Schema(description="An annotation that adds a text markup to a page.")
@JsonPropertyOrder(value={"color", "contents", "creator", "hidden", "intents", "invisible", "locked", "markupType", "name", "opacity", "page", "position", "printable", "rotatable", "subject", "viewable", "writable", "zoomable"})
@JsonTypeName(value="Operation_MarkupAnnotation")
public class OperationMarkupAnnotation {
    public static final String JSON_PROPERTY_COLOR = "color";
    private String color = "#4800FF";
    public static final String JSON_PROPERTY_CONTENTS = "contents";
    private String contents = "";
    public static final String JSON_PROPERTY_CREATOR = "creator";
    private String creator = "";
    public static final String JSON_PROPERTY_HIDDEN = "hidden";
    private Boolean hidden = false;
    public static final String JSON_PROPERTY_INTENTS = "intents";
    private String intents = "";
    public static final String JSON_PROPERTY_INVISIBLE = "invisible";
    private Boolean invisible = false;
    public static final String JSON_PROPERTY_LOCKED = "locked";
    private Boolean locked = true;
    public static final String JSON_PROPERTY_MARKUP_TYPE = "markupType";
    private MarkupTypeEnum markupType = MarkupTypeEnum.HIGHLIGHT;
    public static final String JSON_PROPERTY_NAME = "name";
    private String name = "";
    public static final String JSON_PROPERTY_OPACITY = "opacity";
    private Integer opacity = 100;
    public static final String JSON_PROPERTY_PAGE = "page";
    private Integer page = 1;
    public static final String JSON_PROPERTY_POSITION = "position";
    private OperationPositionMarkupAnnotation position;
    public static final String JSON_PROPERTY_PRINTABLE = "printable";
    private Boolean printable = false;
    public static final String JSON_PROPERTY_ROTATABLE = "rotatable";
    private Boolean rotatable = true;
    public static final String JSON_PROPERTY_SUBJECT = "subject";
    private String subject = "";
    public static final String JSON_PROPERTY_VIEWABLE = "viewable";
    private Boolean viewable = true;
    public static final String JSON_PROPERTY_WRITABLE = "writable";
    private Boolean writable = true;
    public static final String JSON_PROPERTY_ZOOMABLE = "zoomable";
    private Boolean zoomable = true;

    public OperationMarkupAnnotation color(String color) {
        this.color = color;
        return this;
    }

    @Schema(name="The annotation color will change the main color of visible annotations. The color needs to be specified as a hexadecimal RGB value with a number sign before it.")
    @JsonProperty(value="color")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getColor() {
        return this.color;
    }

    @JsonProperty(value="color")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setColor(String color) {
        this.color = color;
    }

    public OperationMarkupAnnotation contents(String contents) {
        this.contents = contents;
        return this;
    }

    @Schema(name="This value is used to configure the text content of the annotation, with the way in which it is displayed depending heavily on the specific annotation type (for example, in the case of a text note, this would be the text content of the annotation's popup).")
    @JsonProperty(value="contents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getContents() {
        return this.contents;
    }

    @JsonProperty(value="contents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContents(String contents) {
        this.contents = contents;
    }

    public OperationMarkupAnnotation creator(String creator) {
        this.creator = creator;
        return this;
    }

    @Schema(name="Used to specify the author of the annotation.")
    @JsonProperty(value="creator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getCreator() {
        return this.creator;
    }

    @JsonProperty(value="creator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreator(String creator) {
        this.creator = creator;
    }

    public OperationMarkupAnnotation hidden(Boolean hidden) {
        this.hidden = hidden;
        return this;
    }

    @Schema(name="If this value is set to true, the annotation will not be shown on the page and will not be printed either.")
    @JsonProperty(value="hidden")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getHidden() {
        return this.hidden;
    }

    @JsonProperty(value="hidden")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public OperationMarkupAnnotation intents(String intents) {
        this.intents = intents;
        return this;
    }

    @Schema(name="Used to set the intention of the annotation.  **Important:** The intention of an annotation can directly influence it's behaviour and may serve different purposes for different annotation types. Only set this directly, if you know it is necessary and possible to do so.")
    @JsonProperty(value="intents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getIntents() {
        return this.intents;
    }

    @JsonProperty(value="intents")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIntents(String intents) {
        this.intents = intents;
    }

    public OperationMarkupAnnotation invisible(Boolean invisible) {
        this.invisible = invisible;
        return this;
    }

    @Schema(name="If this value is set to true, the annotation will be visible on the page only when printed, and provided it is a PDF standard annotation.")
    @JsonProperty(value="invisible")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getInvisible() {
        return this.invisible;
    }

    @JsonProperty(value="invisible")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInvisible(Boolean invisible) {
        this.invisible = invisible;
    }

    public OperationMarkupAnnotation locked(Boolean locked) {
        this.locked = locked;
        return this;
    }

    @Schema(name="If this value is set to true, the annotation will be locked so that no changes can be made to it.")
    @JsonProperty(value="locked")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getLocked() {
        return this.locked;
    }

    @JsonProperty(value="locked")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    public OperationMarkupAnnotation markupType(MarkupTypeEnum markupType) {
        this.markupType = markupType;
        return this;
    }

    @Schema(name="Used to set the type of markup. The following values are available:  *   highlight = Highlights text *   underline = Underlines text with a straight line *   strikeOut = Strikes text through *   squiggly = Underlines text with a squiggly line")
    @JsonProperty(value="markupType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public MarkupTypeEnum getMarkupType() {
        return this.markupType;
    }

    @JsonProperty(value="markupType")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMarkupType(MarkupTypeEnum markupType) {
        this.markupType = markupType;
    }

    public OperationMarkupAnnotation name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="Used to specify the name of the annotation.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public OperationMarkupAnnotation opacity(Integer opacity) {
        this.opacity = opacity;
        return this;
    }

    @Schema(name="This percentage value is used to set the annotation's transparency.")
    @JsonProperty(value="opacity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getOpacity() {
        return this.opacity;
    }

    @JsonProperty(value="opacity")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setOpacity(Integer opacity) {
        this.opacity = opacity;
    }

    public OperationMarkupAnnotation page(Integer page) {
        this.page = page;
        return this;
    }

    @Schema(name="Set the number of the page, the annotation shall be placed on.")
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPage(Integer page) {
        this.page = page;
    }

    public OperationMarkupAnnotation position(OperationPositionMarkupAnnotation position) {
        this.position = position;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="position")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationPositionMarkupAnnotation getPosition() {
        return this.position;
    }

    @JsonProperty(value="position")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPosition(OperationPositionMarkupAnnotation position) {
        this.position = position;
    }

    public OperationMarkupAnnotation printable(Boolean printable) {
        this.printable = printable;
        return this;
    }

    @Schema(name="If this value is set to true, the annotation will be included when the page is printed out.")
    @JsonProperty(value="printable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getPrintable() {
        return this.printable;
    }

    @JsonProperty(value="printable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPrintable(Boolean printable) {
        this.printable = printable;
    }

    public OperationMarkupAnnotation rotatable(Boolean rotatable) {
        this.rotatable = rotatable;
        return this;
    }

    @Schema(name="If this value is set to true, the annotation shall be rotatable according to the displayed page rotation.")
    @JsonProperty(value="rotatable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getRotatable() {
        return this.rotatable;
    }

    @JsonProperty(value="rotatable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRotatable(Boolean rotatable) {
        this.rotatable = rotatable;
    }

    public OperationMarkupAnnotation subject(String subject) {
        this.subject = subject;
        return this;
    }

    @Schema(name="Used to specify the subject of the annotation.")
    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubject(String subject) {
        this.subject = subject;
    }

    public OperationMarkupAnnotation viewable(Boolean viewable) {
        this.viewable = viewable;
        return this;
    }

    @Schema(name="If this value is set to true, the annotation will be shown on the document's page.")
    @JsonProperty(value="viewable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getViewable() {
        return this.viewable;
    }

    @JsonProperty(value="viewable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setViewable(Boolean viewable) {
        this.viewable = viewable;
    }

    public OperationMarkupAnnotation writable(Boolean writable) {
        this.writable = writable;
        return this;
    }

    @Schema(name="If this value is set to true, it will be possible to change the annotation's contents later on.")
    @JsonProperty(value="writable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getWritable() {
        return this.writable;
    }

    @JsonProperty(value="writable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setWritable(Boolean writable) {
        this.writable = writable;
    }

    public OperationMarkupAnnotation zoomable(Boolean zoomable) {
        this.zoomable = zoomable;
        return this;
    }

    @Schema(name="If this value is set to true, the annotation will adjust its own zoom factor as required for the page in order to always be clearly readable / recognizable.")
    @JsonProperty(value="zoomable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getZoomable() {
        return this.zoomable;
    }

    @JsonProperty(value="zoomable")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setZoomable(Boolean zoomable) {
        this.zoomable = zoomable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationMarkupAnnotation operationMarkupAnnotation = (OperationMarkupAnnotation)o;
        return Objects.equals(this.color, operationMarkupAnnotation.color) && Objects.equals(this.contents, operationMarkupAnnotation.contents) && Objects.equals(this.creator, operationMarkupAnnotation.creator) && Objects.equals(this.hidden, operationMarkupAnnotation.hidden) && Objects.equals(this.intents, operationMarkupAnnotation.intents) && Objects.equals(this.invisible, operationMarkupAnnotation.invisible) && Objects.equals(this.locked, operationMarkupAnnotation.locked) && Objects.equals((Object)this.markupType, (Object)operationMarkupAnnotation.markupType) && Objects.equals(this.name, operationMarkupAnnotation.name) && Objects.equals(this.opacity, operationMarkupAnnotation.opacity) && Objects.equals(this.page, operationMarkupAnnotation.page) && Objects.equals(this.position, operationMarkupAnnotation.position) && Objects.equals(this.printable, operationMarkupAnnotation.printable) && Objects.equals(this.rotatable, operationMarkupAnnotation.rotatable) && Objects.equals(this.subject, operationMarkupAnnotation.subject) && Objects.equals(this.viewable, operationMarkupAnnotation.viewable) && Objects.equals(this.writable, operationMarkupAnnotation.writable) && Objects.equals(this.zoomable, operationMarkupAnnotation.zoomable);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.color, this.contents, this.creator, this.hidden, this.intents, this.invisible, this.locked, this.markupType, this.name, this.opacity, this.page, this.position, this.printable, this.rotatable, this.subject, this.viewable, this.writable, this.zoomable});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationMarkupAnnotation {\n");
        sb.append("    color: ").append(this.toIndentedString(this.color)).append("\n");
        sb.append("    contents: ").append(this.toIndentedString(this.contents)).append("\n");
        sb.append("    creator: ").append(this.toIndentedString(this.creator)).append("\n");
        sb.append("    hidden: ").append(this.toIndentedString(this.hidden)).append("\n");
        sb.append("    intents: ").append(this.toIndentedString(this.intents)).append("\n");
        sb.append("    invisible: ").append(this.toIndentedString(this.invisible)).append("\n");
        sb.append("    locked: ").append(this.toIndentedString(this.locked)).append("\n");
        sb.append("    markupType: ").append(this.toIndentedString((Object)this.markupType)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    opacity: ").append(this.toIndentedString(this.opacity)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    position: ").append(this.toIndentedString(this.position)).append("\n");
        sb.append("    printable: ").append(this.toIndentedString(this.printable)).append("\n");
        sb.append("    rotatable: ").append(this.toIndentedString(this.rotatable)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("    viewable: ").append(this.toIndentedString(this.viewable)).append("\n");
        sb.append("    writable: ").append(this.toIndentedString(this.writable)).append("\n");
        sb.append("    zoomable: ").append(this.toIndentedString(this.zoomable)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum MarkupTypeEnum {
        HIGHLIGHT("highlight"),
        UNDERLINE("underline"),
        STRIKEOUT("strikeOut"),
        SQUIGGLY("squiggly");

        private String value;

        private MarkupTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static MarkupTypeEnum fromValue(String value) {
            for (MarkupTypeEnum b : MarkupTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

