/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationRectangle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Schema(description="A PDF417 barcode.")
@JsonPropertyOrder(value={"charset", "compact", "compactionMode", "dataCodewordsMax", "dataCodewordsMin", "errorCorrection", "margin", "pages", "position", "rotation", "shape", "symbolsPerCodewordMax", "symbolsPerCodewordMin", "value"})
@JsonTypeName(value="Operation_Pdf417Barcode")
public class OperationPdf417Barcode {
    public static final String JSON_PROPERTY_CHARSET = "charset";
    private String charset = "utf-8";
    public static final String JSON_PROPERTY_COMPACT = "compact";
    private Boolean compact = false;
    public static final String JSON_PROPERTY_COMPACTION_MODE = "compactionMode";
    private CompactionModeEnum compactionMode = CompactionModeEnum.AUTO;
    public static final String JSON_PROPERTY_DATA_CODEWORDS_MAX = "dataCodewordsMax";
    private Integer dataCodewordsMax = 0;
    public static final String JSON_PROPERTY_DATA_CODEWORDS_MIN = "dataCodewordsMin";
    private Integer dataCodewordsMin = 0;
    public static final String JSON_PROPERTY_ERROR_CORRECTION = "errorCorrection";
    private Integer errorCorrection = 2;
    public static final String JSON_PROPERTY_MARGIN = "margin";
    private Integer margin = 0;
    public static final String JSON_PROPERTY_PAGES = "pages";
    private String pages = "";
    public static final String JSON_PROPERTY_POSITION = "position";
    private OperationRectangle position;
    public static final String JSON_PROPERTY_ROTATION = "rotation";
    private Integer rotation = 0;
    public static final String JSON_PROPERTY_SHAPE = "shape";
    private ShapeEnum shape = ShapeEnum.DEFAULT;
    public static final String JSON_PROPERTY_SYMBOLS_PER_CODEWORD_MAX = "symbolsPerCodewordMax";
    private Integer symbolsPerCodewordMax = 0;
    public static final String JSON_PROPERTY_SYMBOLS_PER_CODEWORD_MIN = "symbolsPerCodewordMin";
    private Integer symbolsPerCodewordMin = 0;
    public static final String JSON_PROPERTY_VALUE = "value";
    private String value = "";

    public OperationPdf417Barcode charset(String charset) {
        this.charset = charset;
        return this;
    }

    @Schema(name="Used to specify the character set in which the barcode contents should be stored.")
    @JsonProperty(value="charset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getCharset() {
        return this.charset;
    }

    @JsonProperty(value="charset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCharset(String charset) {
        this.charset = charset;
    }

    public OperationPdf417Barcode compact(Boolean compact) {
        this.compact = compact;
        return this;
    }

    @Schema(name="If this value is set to \"true,\" the contents of all generated PDF417 barcodes will be compressed using the encoding selected with the \"compactionMode\" attribute.")
    @JsonProperty(value="compact")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getCompact() {
        return this.compact;
    }

    @JsonProperty(value="compact")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCompact(Boolean compact) {
        this.compact = compact;
    }

    public OperationPdf417Barcode compactionMode(CompactionModeEnum compactionMode) {
        this.compactionMode = compactionMode;
        return this;
    }

    @Schema(name="If PDF417 barcode compression has been enabled with the \"compact\" attribute, the encoding selected here for the compression of generated PDF417 barcodes will be used.  *   auto = Try to determine the best encoding method automatically. *   byte = Select a byte encoding method in which every 5 codewords represent 6 bytes. *   numeric = Select a numeric encoding method in which a group of 15 codewords represents up to 44 decimal numbers. *   text = Select a text encoding method in which each codeword represents up to 2 letters.")
    @JsonProperty(value="compactionMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public CompactionModeEnum getCompactionMode() {
        return this.compactionMode;
    }

    @JsonProperty(value="compactionMode")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCompactionMode(CompactionModeEnum compactionMode) {
        this.compactionMode = compactionMode;
    }

    public OperationPdf417Barcode dataCodewordsMax(Integer dataCodewordsMax) {
        this.dataCodewordsMax = dataCodewordsMax;
        return this;
    }

    @Schema(name="Used to specify the maximum number of codewords allowed in a single PDF417 barcode row.")
    @JsonProperty(value="dataCodewordsMax")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getDataCodewordsMax() {
        return this.dataCodewordsMax;
    }

    @JsonProperty(value="dataCodewordsMax")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDataCodewordsMax(Integer dataCodewordsMax) {
        this.dataCodewordsMax = dataCodewordsMax;
    }

    public OperationPdf417Barcode dataCodewordsMin(Integer dataCodewordsMin) {
        this.dataCodewordsMin = dataCodewordsMin;
        return this;
    }

    @Schema(name="Used to specify the minimum number of codewords allowed in a single PDF417 barcode row.")
    @JsonProperty(value="dataCodewordsMin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getDataCodewordsMin() {
        return this.dataCodewordsMin;
    }

    @JsonProperty(value="dataCodewordsMin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDataCodewordsMin(Integer dataCodewordsMin) {
        this.dataCodewordsMin = dataCodewordsMin;
    }

    public OperationPdf417Barcode errorCorrection(Integer errorCorrection) {
        this.errorCorrection = errorCorrection;
        return this;
    }

    @Schema(name="Used to adjust the error correction level for generated PDF417 codes. The higher the level, the more error-resistant the barcode, ensuring that damaged codes will still be readable. A level of 1 to 8 can be specified.")
    @JsonProperty(value="errorCorrection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getErrorCorrection() {
        return this.errorCorrection;
    }

    @JsonProperty(value="errorCorrection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setErrorCorrection(Integer errorCorrection) {
        this.errorCorrection = errorCorrection;
    }

    public OperationPdf417Barcode margin(Integer margin) {
        this.margin = margin;
        return this;
    }

    @Schema(name="Used to specify the width of the empty frame that should be generated around the barcode. This shall use the same metrics as the position - if no position is present, the default (mm) shall be assumed.")
    @JsonProperty(value="margin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getMargin() {
        return this.margin;
    }

    @JsonProperty(value="margin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setMargin(Integer margin) {
        this.margin = margin;
    }

    public OperationPdf417Barcode pages(String pages) {
        this.pages = pages;
        return this;
    }

    @Schema(name="The page range for generating barcodes. Individual pages or a range of pages can be defined here. If the text is empty, the entire file will be exported (e.g.: \"1-10\" or \"1,2,5-10\")")
    @JsonProperty(value="pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getPages() {
        return this.pages;
    }

    @JsonProperty(value="pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPages(String pages) {
        this.pages = pages;
    }

    public OperationPdf417Barcode position(OperationRectangle position) {
        this.position = position;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="position")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationRectangle getPosition() {
        return this.position;
    }

    @JsonProperty(value="position")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPosition(OperationRectangle position) {
        this.position = position;
    }

    public OperationPdf417Barcode rotation(Integer rotation) {
        this.rotation = rotation;
        return this;
    }

    @Schema(name="Used to specify the barcode's rotation in 90-degree increments. When there is a value that falls under a full 90-degree increment, the next higher increment will be automatically selected.")
    @JsonProperty(value="rotation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getRotation() {
        return this.rotation;
    }

    @JsonProperty(value="rotation")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRotation(Integer rotation) {
        this.rotation = rotation;
    }

    public OperationPdf417Barcode shape(ShapeEnum shape) {
        this.shape = shape;
        return this;
    }

    @Schema(name="Can be used to force a specific shape for generated Data Matrix codes.  *   default = Select an appropriate shape. *   rectangle = Force a rectangular shape. *   square = Force a square shape.")
    @JsonProperty(value="shape")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public ShapeEnum getShape() {
        return this.shape;
    }

    @JsonProperty(value="shape")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setShape(ShapeEnum shape) {
        this.shape = shape;
    }

    public OperationPdf417Barcode symbolsPerCodewordMax(Integer symbolsPerCodewordMax) {
        this.symbolsPerCodewordMax = symbolsPerCodewordMax;
        return this;
    }

    @Schema(name="Used to specify the maximum number of code symbols that are allowed to be in a single codeword in the PDF417 barcode.")
    @JsonProperty(value="symbolsPerCodewordMax")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getSymbolsPerCodewordMax() {
        return this.symbolsPerCodewordMax;
    }

    @JsonProperty(value="symbolsPerCodewordMax")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSymbolsPerCodewordMax(Integer symbolsPerCodewordMax) {
        this.symbolsPerCodewordMax = symbolsPerCodewordMax;
    }

    public OperationPdf417Barcode symbolsPerCodewordMin(Integer symbolsPerCodewordMin) {
        this.symbolsPerCodewordMin = symbolsPerCodewordMin;
        return this;
    }

    @Schema(name="Used to specify the minimum number of code symbols that are allowed to be in a single codeword in the PDF417 barcode.")
    @JsonProperty(value="symbolsPerCodewordMin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getSymbolsPerCodewordMin() {
        return this.symbolsPerCodewordMin;
    }

    @JsonProperty(value="symbolsPerCodewordMin")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSymbolsPerCodewordMin(Integer symbolsPerCodewordMin) {
        this.symbolsPerCodewordMin = symbolsPerCodewordMin;
    }

    public OperationPdf417Barcode value(String value) {
        this.value = value;
        return this;
    }

    @Schema(required=true, name="Contains the value that should be encoded in the barcode. Depending on the selected barcode format, there may be specific criteria for the data structure. For a description, please refer to the chapter \"Barcodes\"")
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    @NotNull
    public String getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationPdf417Barcode operationPdf417Barcode = (OperationPdf417Barcode)o;
        return Objects.equals(this.charset, operationPdf417Barcode.charset) && Objects.equals(this.compact, operationPdf417Barcode.compact) && Objects.equals((Object)this.compactionMode, (Object)operationPdf417Barcode.compactionMode) && Objects.equals(this.dataCodewordsMax, operationPdf417Barcode.dataCodewordsMax) && Objects.equals(this.dataCodewordsMin, operationPdf417Barcode.dataCodewordsMin) && Objects.equals(this.errorCorrection, operationPdf417Barcode.errorCorrection) && Objects.equals(this.margin, operationPdf417Barcode.margin) && Objects.equals(this.pages, operationPdf417Barcode.pages) && Objects.equals(this.position, operationPdf417Barcode.position) && Objects.equals(this.rotation, operationPdf417Barcode.rotation) && Objects.equals((Object)this.shape, (Object)operationPdf417Barcode.shape) && Objects.equals(this.symbolsPerCodewordMax, operationPdf417Barcode.symbolsPerCodewordMax) && Objects.equals(this.symbolsPerCodewordMin, operationPdf417Barcode.symbolsPerCodewordMin) && Objects.equals(this.value, operationPdf417Barcode.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.charset, this.compact, this.compactionMode, this.dataCodewordsMax, this.dataCodewordsMin, this.errorCorrection, this.margin, this.pages, this.position, this.rotation, this.shape, this.symbolsPerCodewordMax, this.symbolsPerCodewordMin, this.value});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationPdf417Barcode {\n");
        sb.append("    charset: ").append(this.toIndentedString(this.charset)).append("\n");
        sb.append("    compact: ").append(this.toIndentedString(this.compact)).append("\n");
        sb.append("    compactionMode: ").append(this.toIndentedString((Object)this.compactionMode)).append("\n");
        sb.append("    dataCodewordsMax: ").append(this.toIndentedString(this.dataCodewordsMax)).append("\n");
        sb.append("    dataCodewordsMin: ").append(this.toIndentedString(this.dataCodewordsMin)).append("\n");
        sb.append("    errorCorrection: ").append(this.toIndentedString(this.errorCorrection)).append("\n");
        sb.append("    margin: ").append(this.toIndentedString(this.margin)).append("\n");
        sb.append("    pages: ").append(this.toIndentedString(this.pages)).append("\n");
        sb.append("    position: ").append(this.toIndentedString(this.position)).append("\n");
        sb.append("    rotation: ").append(this.toIndentedString(this.rotation)).append("\n");
        sb.append("    shape: ").append(this.toIndentedString((Object)this.shape)).append("\n");
        sb.append("    symbolsPerCodewordMax: ").append(this.toIndentedString(this.symbolsPerCodewordMax)).append("\n");
        sb.append("    symbolsPerCodewordMin: ").append(this.toIndentedString(this.symbolsPerCodewordMin)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ShapeEnum {
        DEFAULT("default"),
        RECTANGLE("rectangle"),
        SQUARE("square");

        private String value;

        private ShapeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ShapeEnum fromValue(String value) {
            for (ShapeEnum b : ShapeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum CompactionModeEnum {
        TEXT("text"),
        NUMERIC("numeric"),
        BYTE("byte"),
        AUTO("auto");

        private String value;

        private CompactionModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CompactionModeEnum fromValue(String value) {
            for (CompactionModeEnum b : CompactionModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

