/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="The `pdfa` element allows to make settings for automatic handling of PDF/A documents. Editing a PDF/A document will most likely render it invalid, thus the web service operation checks whether it\u00b4s execution is valid for a given PDF/A document according to these settings.")
@JsonPropertyOrder(value={"pdfaEditProfile"})
@JsonTypeName(value="Operation_PdfaSettings")
public class OperationPdfaSettings {
    public static final String JSON_PROPERTY_PDFA_EDIT_PROFILE = "pdfaEditProfile";
    private PdfaEditProfileEnum pdfaEditProfile = PdfaEditProfileEnum.REMOVEPDFAMETADATA;

    public OperationPdfaSettings pdfaEditProfile(PdfaEditProfileEnum pdfaEditProfile) {
        this.pdfaEditProfile = pdfaEditProfile;
        return this;
    }

    @Schema(name="Defines the profile whose rules web services have to check before they can come to execution. These profiles define a set of rules concerning the validity of PDF/A documents. A web service whose execution for a given PDF/A document would violate the rule set selected here should instead abort with an appropriate error code.  *   generalEditRestrictions = All changes to PDF/A documents are prohibited. *   removePdfaMetadata = All changes to PDF/A documents are allowed, but the PDF/A state of the document is revoked. (By removing the PDF/A metadata.) *   noEditRestrictions = All changes to PDF/A documents are allowed, without touching the PDF/A state of the document. (Risking the invalidation of the document.)")
    @JsonProperty(value="pdfaEditProfile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public PdfaEditProfileEnum getPdfaEditProfile() {
        return this.pdfaEditProfile;
    }

    @JsonProperty(value="pdfaEditProfile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPdfaEditProfile(PdfaEditProfileEnum pdfaEditProfile) {
        this.pdfaEditProfile = pdfaEditProfile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationPdfaSettings operationPdfaSettings = (OperationPdfaSettings)o;
        return Objects.equals((Object)this.pdfaEditProfile, (Object)operationPdfaSettings.pdfaEditProfile);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.pdfaEditProfile});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationPdfaSettings {\n");
        sb.append("    pdfaEditProfile: ").append(this.toIndentedString((Object)this.pdfaEditProfile)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum PdfaEditProfileEnum {
        GENERALEDITRESTRICTIONS("generalEditRestrictions"),
        REMOVEPDFAMETADATA("removePdfaMetadata"),
        NOEDITRESTRICTIONS("noEditRestrictions");

        private String value;

        private PdfaEditProfileEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PdfaEditProfileEnum fromValue(String value) {
            for (PdfaEditProfileEnum b : PdfaEditProfileEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

