/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationPortfolioSelection;
import org.jetbrains.annotations.Nullable;

@Schema(description="Extracts one or more documents from the portfolio. The result will be returned as a ZIP document. The ZIP document will not only contain the extracted files, but will also reproduce the folder structure in which the documents were found.")
@JsonPropertyOrder(value={"selection", "singleFileAsZip"})
@JsonTypeName(value="Operation_PortfolioExtract")
public class OperationPortfolioExtract {
    public static final String JSON_PROPERTY_SELECTION = "selection";
    private List<OperationPortfolioSelection> selection = null;
    public static final String JSON_PROPERTY_SINGLE_FILE_AS_ZIP = "singleFileAsZip";
    private Boolean singleFileAsZip = true;

    public OperationPortfolioExtract selection(List<OperationPortfolioSelection> selection) {
        this.selection = selection;
        return this;
    }

    public OperationPortfolioExtract addSelectionItem(OperationPortfolioSelection selectionItem) {
        if (this.selection == null) {
            this.selection = new ArrayList<OperationPortfolioSelection>();
        }
        this.selection.add(selectionItem);
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="selection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public List<OperationPortfolioSelection> getSelection() {
        return this.selection;
    }

    @JsonProperty(value="selection")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSelection(List<OperationPortfolioSelection> selection) {
        this.selection = selection;
    }

    public OperationPortfolioExtract singleFileAsZip(Boolean singleFileAsZip) {
        this.singleFileAsZip = singleFileAsZip;
        return this;
    }

    @Schema(name="The returned attachments will be generated as a ZIP file even if selection is used to select only one single file. You can change this behaviour by setting this option to \"false\". In this case, the file will not be zipped, and will instead be returned directly as is. However, this will only work if selection has been used to select one file and one file only.")
    @JsonProperty(value="singleFileAsZip")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getSingleFileAsZip() {
        return this.singleFileAsZip;
    }

    @JsonProperty(value="singleFileAsZip")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSingleFileAsZip(Boolean singleFileAsZip) {
        this.singleFileAsZip = singleFileAsZip;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationPortfolioExtract operationPortfolioExtract = (OperationPortfolioExtract)o;
        return Objects.equals(this.selection, operationPortfolioExtract.selection) && Objects.equals(this.singleFileAsZip, operationPortfolioExtract.singleFileAsZip);
    }

    public int hashCode() {
        return Objects.hash(this.selection, this.singleFileAsZip);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationPortfolioExtract {\n");
        sb.append("    selection: ").append(this.toIndentedString(this.selection)).append("\n");
        sb.append("    singleFileAsZip: ").append(this.toIndentedString(this.singleFileAsZip)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

