/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="Allows the private key to be passed (as a PEM file), for decryption of an asymmetrically encrypted document. The transfer of multiple private keys or other structures is not provided for at this point; exactly one private key is expected for decrypting the document. The rights recipient must already be assigned to the document when the document is encrypted. The certificate and private key must therefore be selected in such a way that they map a rights recipient who was entered in this document when it was encrypted.")
@JsonPropertyOrder(value={"password", "source", "uri", "value"})
@JsonTypeName(value="Operation_PrivateKeyFileData")
public class OperationPrivateKeyFileData {
    public static final String JSON_PROPERTY_PASSWORD = "password";
    private String password = "";
    public static final String JSON_PROPERTY_SOURCE = "source";
    private SourceEnum source = SourceEnum.VALUE;
    public static final String JSON_PROPERTY_URI = "uri";
    private String uri = "";
    public static final String JSON_PROPERTY_VALUE = "value";
    private String value = "";

    public OperationPrivateKeyFileData password(String password) {
        this.password = password;
        return this;
    }

    @Schema(name="If the private key itself is encrypted (recommended), this password allows read access to the key to make it available for decrypting the document.")
    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getPassword() {
        return this.password;
    }

    @JsonProperty(value="password")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPassword(String password) {
        this.password = password;
    }

    public OperationPrivateKeyFileData source(SourceEnum source) {
        this.source = source;
        return this;
    }

    @Schema(name="Selects the data source for the hereby expressed resource. Possible values are:  *   value = The element's value shall contain the BASE64 encoded data. *   uri = The data shall be located at the given uri.")
    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public SourceEnum getSource() {
        return this.source;
    }

    @JsonProperty(value="source")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSource(SourceEnum source) {
        this.source = source;
    }

    public OperationPrivateKeyFileData uri(String uri) {
        this.uri = uri;
        return this;
    }

    @Schema(name="The uri the data shall be located at. (This shall only have effect, if the \"source\" is \"uri\".)")
    @JsonProperty(value="uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getUri() {
        return this.uri;
    }

    @JsonProperty(value="uri")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUri(String uri) {
        this.uri = uri;
    }

    public OperationPrivateKeyFileData value(String value) {
        this.value = value;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getValue() {
        return this.value;
    }

    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationPrivateKeyFileData operationPrivateKeyFileData = (OperationPrivateKeyFileData)o;
        return Objects.equals(this.password, operationPrivateKeyFileData.password) && Objects.equals((Object)this.source, (Object)operationPrivateKeyFileData.source) && Objects.equals(this.uri, operationPrivateKeyFileData.uri) && Objects.equals(this.value, operationPrivateKeyFileData.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.password, this.source, this.uri, this.value});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationPrivateKeyFileData {\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    source: ").append(this.toIndentedString((Object)this.source)).append("\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum SourceEnum {
        VALUE("value"),
        URI("uri");

        private String value;

        private SourceEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SourceEnum fromValue(String value) {
            for (SourceEnum b : SourceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

