/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="An annotation, that provides a \"reply state\" for a selected annotation.")
@JsonPropertyOrder(value={"creator", "name", "page", "replyState", "replyTo", "subject"})
@JsonTypeName(value="Operation_ReplyStateAnnotation")
public class OperationReplyStateAnnotation {
    public static final String JSON_PROPERTY_CREATOR = "creator";
    private String creator = "";
    public static final String JSON_PROPERTY_NAME = "name";
    private String name = "";
    public static final String JSON_PROPERTY_PAGE = "page";
    private Integer page = 1;
    public static final String JSON_PROPERTY_REPLY_STATE = "replyState";
    private ReplyStateEnum replyState = ReplyStateEnum.NONE;
    public static final String JSON_PROPERTY_REPLY_TO = "replyTo";
    private String replyTo = "";
    public static final String JSON_PROPERTY_SUBJECT = "subject";
    private String subject = "";

    public OperationReplyStateAnnotation creator(String creator) {
        this.creator = creator;
        return this;
    }

    @Schema(name="Used to specify the author of the annotation.")
    @JsonProperty(value="creator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getCreator() {
        return this.creator;
    }

    @JsonProperty(value="creator")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreator(String creator) {
        this.creator = creator;
    }

    public OperationReplyStateAnnotation name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="Used to specify the name of the annotation.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setName(String name) {
        this.name = name;
    }

    public OperationReplyStateAnnotation page(Integer page) {
        this.page = page;
        return this;
    }

    @Schema(name="Set the number of the page, the annotation shall be placed on.  **Important:** A reply shall always be placed on the same page as it's target annotation. This is mostly providing a hint where to find the selected annotation.")
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPage(Integer page) {
        this.page = page;
    }

    public OperationReplyStateAnnotation replyState(ReplyStateEnum replyState) {
        this.replyState = replyState;
        return this;
    }

    @Schema(name="Adds a mark for further processing suggestions/instructions to a commenting annotation.  *   accepted = The user agrees with the change. *   rejected = The user disagrees with the change. *   cancelled = The change has been cancelled. *   completed = The change has been completed. *   none = The user did not set a state.")
    @JsonProperty(value="replyState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public ReplyStateEnum getReplyState() {
        return this.replyState;
    }

    @JsonProperty(value="replyState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReplyState(ReplyStateEnum replyState) {
        this.replyState = replyState;
    }

    public OperationReplyStateAnnotation replyTo(String replyTo) {
        this.replyTo = replyTo;
        return this;
    }

    @Schema(name="Selects the object id of the annotation, that this annotation shall be a reply to. The object id shall be given as a String that may contain either:  *   The numeric object ID itself *   The object ID followed by the generation number, separated by a space")
    @JsonProperty(value="replyTo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getReplyTo() {
        return this.replyTo;
    }

    @JsonProperty(value="replyTo")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public OperationReplyStateAnnotation subject(String subject) {
        this.subject = subject;
        return this;
    }

    @Schema(name="Used to specify the subject of the annotation.")
    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getSubject() {
        return this.subject;
    }

    @JsonProperty(value="subject")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubject(String subject) {
        this.subject = subject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationReplyStateAnnotation operationReplyStateAnnotation = (OperationReplyStateAnnotation)o;
        return Objects.equals(this.creator, operationReplyStateAnnotation.creator) && Objects.equals(this.name, operationReplyStateAnnotation.name) && Objects.equals(this.page, operationReplyStateAnnotation.page) && Objects.equals((Object)this.replyState, (Object)operationReplyStateAnnotation.replyState) && Objects.equals(this.replyTo, operationReplyStateAnnotation.replyTo) && Objects.equals(this.subject, operationReplyStateAnnotation.subject);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.creator, this.name, this.page, this.replyState, this.replyTo, this.subject});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationReplyStateAnnotation {\n");
        sb.append("    creator: ").append(this.toIndentedString(this.creator)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    page: ").append(this.toIndentedString(this.page)).append("\n");
        sb.append("    replyState: ").append(this.toIndentedString((Object)this.replyState)).append("\n");
        sb.append("    replyTo: ").append(this.toIndentedString(this.replyTo)).append("\n");
        sb.append("    subject: ").append(this.toIndentedString(this.subject)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ReplyStateEnum {
        ACCEPTED("accepted"),
        REJECTED("rejected"),
        CANCELLED("cancelled"),
        COMPLETED("completed"),
        NONE("none");

        private String value;

        private ReplyStateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ReplyStateEnum fromValue(String value) {
            for (ReplyStateEnum b : ReplyStateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

