/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@Schema(description="If this function is enabled, all the selected pages in the document will be flattened. When this is done, an image of the visible contents in the corresponding page will be generated and will be used to replace all the page contents. This will remove any complex content that may be hiding confidential data.")
@JsonPropertyOrder(value={"dpi", "enabled", "pages"})
@JsonTypeName(value="Operation_SanitizePages")
public class OperationSanitizePages {
    public static final String JSON_PROPERTY_DPI = "dpi";
    private Integer dpi = 72;
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled = true;
    public static final String JSON_PROPERTY_PAGES = "pages";
    private String pages = "*";

    public OperationSanitizePages dpi(Integer dpi) {
        this.dpi = dpi;
        return this;
    }

    @Schema(name="Used to specify the resolution for the image being generated. Higher resolutions will result in lower quality loss, but may also result in significantly larger document sizes.")
    @JsonProperty(value="dpi")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Integer getDpi() {
        return this.dpi;
    }

    @JsonProperty(value="dpi")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDpi(Integer dpi) {
        this.dpi = dpi;
    }

    public OperationSanitizePages enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Schema(name="If set to \"false\", this sanitize operation shall not be applied.")
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public OperationSanitizePages pages(String pages) {
        this.pages = pages;
        return this;
    }

    @Schema(name="Defines which page(s) should be flattened. The page number can be an individual page, a page range, or a list (separated with commas) (e.g., \"1,5-6,9\"). To specify \"all pages,\" use an asterisk (\"\\*\").")
    @JsonProperty(value="pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getPages() {
        return this.pages;
    }

    @JsonProperty(value="pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPages(String pages) {
        this.pages = pages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationSanitizePages operationSanitizePages = (OperationSanitizePages)o;
        return Objects.equals(this.dpi, operationSanitizePages.dpi) && Objects.equals(this.enabled, operationSanitizePages.enabled) && Objects.equals(this.pages, operationSanitizePages.pages);
    }

    public int hashCode() {
        return Objects.hash(this.dpi, this.enabled, this.pages);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationSanitizePages {\n");
        sb.append("    dpi: ").append(this.toIndentedString(this.dpi)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    pages: ").append(this.toIndentedString(this.pages)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

