/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationPaddedRectangle;
import org.jetbrains.annotations.Nullable;

@Schema(description="Used to define page scaling operations.")
@JsonPropertyOrder(value={"dimensions", "horizontalAlignment", "pages", "preserveAspectRatio", "scaleBoxes", "verticalAlignment"})
@JsonTypeName(value="Operation_ScalePagesToolboxScale")
public class OperationScalePagesToolboxScale {
    public static final String JSON_PROPERTY_DIMENSIONS = "dimensions";
    private OperationPaddedRectangle dimensions;
    public static final String JSON_PROPERTY_HORIZONTAL_ALIGNMENT = "horizontalAlignment";
    private String horizontalAlignment = "left";
    public static final String JSON_PROPERTY_PAGES = "pages";
    private String pages = "";
    public static final String JSON_PROPERTY_PRESERVE_ASPECT_RATIO = "preserveAspectRatio";
    private Boolean preserveAspectRatio = true;
    public static final String JSON_PROPERTY_SCALE_BOXES = "scaleBoxes";
    private Boolean scaleBoxes = true;
    public static final String JSON_PROPERTY_VERTICAL_ALIGNMENT = "verticalAlignment";
    private String verticalAlignment = "top";

    public OperationScalePagesToolboxScale dimensions(OperationPaddedRectangle dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="dimensions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public OperationPaddedRectangle getDimensions() {
        return this.dimensions;
    }

    @JsonProperty(value="dimensions")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDimensions(OperationPaddedRectangle dimensions) {
        this.dimensions = dimensions;
    }

    public OperationScalePagesToolboxScale horizontalAlignment(String horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        return this;
    }

    @Schema(name="If margins are created when the page is scaled or if the page content must be positioned relative to a context (for example, the crop box), this value specifies how margins are to be split and how overall page content is to be positioned on the page.  *   left = Contents are to be arranged left-justified. *   center = Content should be centered. *   right = Contents should be arranged right-justified.")
    @JsonProperty(value="horizontalAlignment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    @JsonProperty(value="horizontalAlignment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setHorizontalAlignment(String horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
    }

    public OperationScalePagesToolboxScale pages(String pages) {
        this.pages = pages;
        return this;
    }

    @Schema(name="Specifies which page(s) should be scaled. The page number can be either a single page, a range of pages or a list (separated by commas) (e.g. \"1.5-6.9\"). The specification of all pages is done with \"\\*\".")
    @JsonProperty(value="pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getPages() {
        return this.pages;
    }

    @JsonProperty(value="pages")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPages(String pages) {
        this.pages = pages;
    }

    public OperationScalePagesToolboxScale preserveAspectRatio(Boolean preserveAspectRatio) {
        this.preserveAspectRatio = preserveAspectRatio;
        return this;
    }

    @Schema(name="Specifies whether the ratio of the page dimensions to each other should be maintained when scaling the page. This may result in deviations from the given target height or width (depending on requirements).")
    @JsonProperty(value="preserveAspectRatio")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getPreserveAspectRatio() {
        return this.preserveAspectRatio;
    }

    @JsonProperty(value="preserveAspectRatio")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPreserveAspectRatio(Boolean preserveAspectRatio) {
        this.preserveAspectRatio = preserveAspectRatio;
    }

    public OperationScalePagesToolboxScale scaleBoxes(Boolean scaleBoxes) {
        this.scaleBoxes = scaleBoxes;
        return this;
    }

    @Schema(name="Specifies whether the scaling of the page should also affect the boxes (Mediabox, Cropbox, etc.) of a page. If this is not the case (false), the actual page dimensions, crop boxes, etc. remain as they were originally and only page contents are scaled. The content can become much smaller or larger than the containing page in this way, which can lead to either large blank areas or overflow of the page content.")
    @JsonProperty(value="scaleBoxes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getScaleBoxes() {
        return this.scaleBoxes;
    }

    @JsonProperty(value="scaleBoxes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScaleBoxes(Boolean scaleBoxes) {
        this.scaleBoxes = scaleBoxes;
    }

    public OperationScalePagesToolboxScale verticalAlignment(String verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
        return this;
    }

    @Schema(name="If margins are created when the page is scaled or if the page content must be positioned relative to a context (for example, the crop box), this value specifies how margins are to be split and how overall page content is to be positioned on the page.  *   top = Content should be positioned at the top of the page. *   center = Content should be centered. *   bottom = content should be positioned at the bottom.")
    @JsonProperty(value="verticalAlignment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getVerticalAlignment() {
        return this.verticalAlignment;
    }

    @JsonProperty(value="verticalAlignment")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setVerticalAlignment(String verticalAlignment) {
        this.verticalAlignment = verticalAlignment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationScalePagesToolboxScale operationScalePagesToolboxScale = (OperationScalePagesToolboxScale)o;
        return Objects.equals(this.dimensions, operationScalePagesToolboxScale.dimensions) && Objects.equals(this.horizontalAlignment, operationScalePagesToolboxScale.horizontalAlignment) && Objects.equals(this.pages, operationScalePagesToolboxScale.pages) && Objects.equals(this.preserveAspectRatio, operationScalePagesToolboxScale.preserveAspectRatio) && Objects.equals(this.scaleBoxes, operationScalePagesToolboxScale.scaleBoxes) && Objects.equals(this.verticalAlignment, operationScalePagesToolboxScale.verticalAlignment);
    }

    public int hashCode() {
        return Objects.hash(this.dimensions, this.horizontalAlignment, this.pages, this.preserveAspectRatio, this.scaleBoxes, this.verticalAlignment);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationScalePagesToolboxScale {\n");
        sb.append("    dimensions: ").append(this.toIndentedString(this.dimensions)).append("\n");
        sb.append("    horizontalAlignment: ").append(this.toIndentedString(this.horizontalAlignment)).append("\n");
        sb.append("    pages: ").append(this.toIndentedString(this.pages)).append("\n");
        sb.append("    preserveAspectRatio: ").append(this.toIndentedString(this.preserveAspectRatio)).append("\n");
        sb.append("    scaleBoxes: ").append(this.toIndentedString(this.scaleBoxes)).append("\n");
        sb.append("    verticalAlignment: ").append(this.toIndentedString(this.verticalAlignment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

