/*
 * Decompiled with CFR 0.152.
 */
package net.webpdf.wsclient.openapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.webpdf.wsclient.openapi.OperationFormFieldSelection;
import org.jetbrains.annotations.Nullable;

@Schema(description="When activated, the submitForm action will send the names and values of all selected form fields to the specified URL (Uniform Resource Locator). You can use the \"field\" element as many times as necessary.")
@JsonPropertyOrder(value={"canonicalFormat", "embedForm", "exclude", "excludeFDFSourceOrTargetFile", "excludeNonUserAnnotations", "exportFormat", "field", "getMethod", "includeAnnotations", "includeAppendSaves", "includeNoValueFields", "submitCoordinates", "submitPDF", "url", "xfdf"})
@JsonTypeName(value="Operation_SubmitFormAction_submitForm")
public class OperationSubmitFormActionSubmitForm {
    public static final String JSON_PROPERTY_CANONICAL_FORMAT = "canonicalFormat";
    private Boolean canonicalFormat = false;
    public static final String JSON_PROPERTY_EMBED_FORM = "embedForm";
    private Boolean embedForm = false;
    public static final String JSON_PROPERTY_EXCLUDE = "exclude";
    private Boolean exclude = false;
    public static final String JSON_PROPERTY_EXCLUDE_F_D_F_SOURCE_OR_TARGET_FILE = "excludeFDFSourceOrTargetFile";
    private Boolean excludeFDFSourceOrTargetFile = false;
    public static final String JSON_PROPERTY_EXCLUDE_NON_USER_ANNOTATIONS = "excludeNonUserAnnotations";
    private Boolean excludeNonUserAnnotations = false;
    public static final String JSON_PROPERTY_EXPORT_FORMAT = "exportFormat";
    private Boolean exportFormat = false;
    public static final String JSON_PROPERTY_FIELD = "field";
    private List<OperationFormFieldSelection> field = null;
    public static final String JSON_PROPERTY_GET_METHOD = "getMethod";
    private Boolean getMethod = false;
    public static final String JSON_PROPERTY_INCLUDE_ANNOTATIONS = "includeAnnotations";
    private Boolean includeAnnotations = false;
    public static final String JSON_PROPERTY_INCLUDE_APPEND_SAVES = "includeAppendSaves";
    private Boolean includeAppendSaves = false;
    public static final String JSON_PROPERTY_INCLUDE_NO_VALUE_FIELDS = "includeNoValueFields";
    private Boolean includeNoValueFields = false;
    public static final String JSON_PROPERTY_SUBMIT_COORDINATES = "submitCoordinates";
    private Boolean submitCoordinates = false;
    public static final String JSON_PROPERTY_SUBMIT_P_D_F = "submitPDF";
    private Boolean submitPDF = false;
    public static final String JSON_PROPERTY_URL = "url";
    private String url = "";
    public static final String JSON_PROPERTY_XFDF = "xfdf";
    private Boolean xfdf = false;

    public OperationSubmitFormActionSubmitForm canonicalFormat(Boolean canonicalFormat) {
        this.canonicalFormat = canonicalFormat;
        return this;
    }

    @Schema(name="If this value is set to true, all dates and times will be transmitted in a canonical standard format whenever possible.")
    @JsonProperty(value="canonicalFormat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getCanonicalFormat() {
        return this.canonicalFormat;
    }

    @JsonProperty(value="canonicalFormat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCanonicalFormat(Boolean canonicalFormat) {
        this.canonicalFormat = canonicalFormat;
    }

    public OperationSubmitFormActionSubmitForm embedForm(Boolean embedForm) {
        this.embedForm = embedForm;
        return this;
    }

    @Schema(name="This value is only relevant if the data should be transmitted in FDF format. In this case, this value determines whether the PDF file that contains the form should be integrated into the transmitted data.")
    @JsonProperty(value="embedForm")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getEmbedForm() {
        return this.embedForm;
    }

    @JsonProperty(value="embedForm")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEmbedForm(Boolean embedForm) {
        this.embedForm = embedForm;
    }

    public OperationSubmitFormActionSubmitForm exclude(Boolean exclude) {
        this.exclude = exclude;
        return this;
    }

    @Schema(name="If true, then all form fields except the selected ones should be exported. If false, only the selected ones will be.")
    @JsonProperty(value="exclude")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getExclude() {
        return this.exclude;
    }

    @JsonProperty(value="exclude")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExclude(Boolean exclude) {
        this.exclude = exclude;
    }

    public OperationSubmitFormActionSubmitForm excludeFDFSourceOrTargetFile(Boolean excludeFDFSourceOrTargetFile) {
        this.excludeFDFSourceOrTargetFile = excludeFDFSourceOrTargetFile;
        return this;
    }

    @Schema(name="This value is only relevant if the data should be transmitted in FDF format. In this case, this value determines whether the URL to which the data is being transmitted should be included in the export.")
    @JsonProperty(value="excludeFDFSourceOrTargetFile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getExcludeFDFSourceOrTargetFile() {
        return this.excludeFDFSourceOrTargetFile;
    }

    @JsonProperty(value="excludeFDFSourceOrTargetFile")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExcludeFDFSourceOrTargetFile(Boolean excludeFDFSourceOrTargetFile) {
        this.excludeFDFSourceOrTargetFile = excludeFDFSourceOrTargetFile;
    }

    public OperationSubmitFormActionSubmitForm excludeNonUserAnnotations(Boolean excludeNonUserAnnotations) {
        this.excludeNonUserAnnotations = excludeNonUserAnnotations;
        return this;
    }

    @Schema(name="This value is only relevant if the data should be transmitted in FDF format and \"includeAnnotations\" is set. In this case, this value determines whether the transmitted data should exclusively contain the annotations set by the user filling out the information (true) or whether it should contain all annotations instead (false).")
    @JsonProperty(value="excludeNonUserAnnotations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getExcludeNonUserAnnotations() {
        return this.excludeNonUserAnnotations;
    }

    @JsonProperty(value="excludeNonUserAnnotations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExcludeNonUserAnnotations(Boolean excludeNonUserAnnotations) {
        this.excludeNonUserAnnotations = excludeNonUserAnnotations;
    }

    public OperationSubmitFormActionSubmitForm exportFormat(Boolean exportFormat) {
        this.exportFormat = exportFormat;
        return this;
    }

    @Schema(name="This value is only relevant if \"submitPDF\" and \"xfdf\" are not set. If this value is set to true, the data will be exported as an HTML form; otherwise, it will be exported in fdf (Forms Data Format) format.")
    @JsonProperty(value="exportFormat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getExportFormat() {
        return this.exportFormat;
    }

    @JsonProperty(value="exportFormat")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExportFormat(Boolean exportFormat) {
        this.exportFormat = exportFormat;
    }

    public OperationSubmitFormActionSubmitForm field(List<OperationFormFieldSelection> field) {
        this.field = field;
        return this;
    }

    public OperationSubmitFormActionSubmitForm addFieldItem(OperationFormFieldSelection fieldItem) {
        if (this.field == null) {
            this.field = new ArrayList<OperationFormFieldSelection>();
        }
        this.field.add(fieldItem);
        return this;
    }

    @Schema(name="")
    @JsonProperty(value="field")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public List<OperationFormFieldSelection> getField() {
        return this.field;
    }

    @JsonProperty(value="field")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setField(List<OperationFormFieldSelection> field) {
        this.field = field;
    }

    public OperationSubmitFormActionSubmitForm getMethod(Boolean getMethod) {
        this.getMethod = getMethod;
        return this;
    }

    @Schema(name="This value is only relevant if \"exportFormat\" is set and used. In this case, this value determines whether the names and values will be transmitted with GET (true) or HTTP POST (false) requests.")
    @JsonProperty(value="getMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getGetMethod() {
        return this.getMethod;
    }

    @JsonProperty(value="getMethod")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGetMethod(Boolean getMethod) {
        this.getMethod = getMethod;
    }

    public OperationSubmitFormActionSubmitForm includeAnnotations(Boolean includeAnnotations) {
        this.includeAnnotations = includeAnnotations;
        return this;
    }

    @Schema(name="This value is only relevant if the data should be transmitted in FDF format. In this case, this value determines whether the set mark-up annotations should be included in the transmitted data.")
    @JsonProperty(value="includeAnnotations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getIncludeAnnotations() {
        return this.includeAnnotations;
    }

    @JsonProperty(value="includeAnnotations")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeAnnotations(Boolean includeAnnotations) {
        this.includeAnnotations = includeAnnotations;
    }

    public OperationSubmitFormActionSubmitForm includeAppendSaves(Boolean includeAppendSaves) {
        this.includeAppendSaves = includeAppendSaves;
        return this;
    }

    @Schema(name="This value is only relevant if the data should be transmitted in FDF format. In this case, this value determines whether the transmitted data will reproduce all incremental changes in the form data.")
    @JsonProperty(value="includeAppendSaves")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getIncludeAppendSaves() {
        return this.includeAppendSaves;
    }

    @JsonProperty(value="includeAppendSaves")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeAppendSaves(Boolean includeAppendSaves) {
        this.includeAppendSaves = includeAppendSaves;
    }

    public OperationSubmitFormActionSubmitForm includeNoValueFields(Boolean includeNoValueFields) {
        this.includeNoValueFields = includeNoValueFields;
        return this;
    }

    @Schema(name="If true, form fields that have not yet been filled out / that do not contain a value will be exported as well.")
    @JsonProperty(value="includeNoValueFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getIncludeNoValueFields() {
        return this.includeNoValueFields;
    }

    @JsonProperty(value="includeNoValueFields")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIncludeNoValueFields(Boolean includeNoValueFields) {
        this.includeNoValueFields = includeNoValueFields;
    }

    public OperationSubmitFormActionSubmitForm submitCoordinates(Boolean submitCoordinates) {
        this.submitCoordinates = submitCoordinates;
        return this;
    }

    @Schema(name="This value is only relevant if \"exportFormat\" is set and used. In this case, this value determines whether the position of the mouse click that triggered the export should also be part of the export.")
    @JsonProperty(value="submitCoordinates")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getSubmitCoordinates() {
        return this.submitCoordinates;
    }

    @JsonProperty(value="submitCoordinates")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubmitCoordinates(Boolean submitCoordinates) {
        this.submitCoordinates = submitCoordinates;
    }

    public OperationSubmitFormActionSubmitForm submitPDF(Boolean submitPDF) {
        this.submitPDF = submitPDF;
        return this;
    }

    @Schema(name="If this value is set to true, the data will be transmitted as a PDF file.")
    @JsonProperty(value="submitPDF")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getSubmitPDF() {
        return this.submitPDF;
    }

    @JsonProperty(value="submitPDF")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubmitPDF(Boolean submitPDF) {
        this.submitPDF = submitPDF;
    }

    public OperationSubmitFormActionSubmitForm url(String url) {
        this.url = url;
        return this;
    }

    @Schema(name="The URL to which the data should be transmitted.")
    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public String getUrl() {
        return this.url;
    }

    @JsonProperty(value="url")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUrl(String url) {
        this.url = url;
    }

    public OperationSubmitFormActionSubmitForm xfdf(Boolean xfdf) {
        this.xfdf = xfdf;
        return this;
    }

    @Schema(name="This value is only relevant if \"submitPDF\" is not set. In this case, this value determines whether the data should be transmitted in XFDF format.")
    @JsonProperty(value="xfdf")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    @Nullable
    public Boolean getXfdf() {
        return this.xfdf;
    }

    @JsonProperty(value="xfdf")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setXfdf(Boolean xfdf) {
        this.xfdf = xfdf;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationSubmitFormActionSubmitForm operationSubmitFormActionSubmitForm = (OperationSubmitFormActionSubmitForm)o;
        return Objects.equals(this.canonicalFormat, operationSubmitFormActionSubmitForm.canonicalFormat) && Objects.equals(this.embedForm, operationSubmitFormActionSubmitForm.embedForm) && Objects.equals(this.exclude, operationSubmitFormActionSubmitForm.exclude) && Objects.equals(this.excludeFDFSourceOrTargetFile, operationSubmitFormActionSubmitForm.excludeFDFSourceOrTargetFile) && Objects.equals(this.excludeNonUserAnnotations, operationSubmitFormActionSubmitForm.excludeNonUserAnnotations) && Objects.equals(this.exportFormat, operationSubmitFormActionSubmitForm.exportFormat) && Objects.equals(this.field, operationSubmitFormActionSubmitForm.field) && Objects.equals(this.getMethod, operationSubmitFormActionSubmitForm.getMethod) && Objects.equals(this.includeAnnotations, operationSubmitFormActionSubmitForm.includeAnnotations) && Objects.equals(this.includeAppendSaves, operationSubmitFormActionSubmitForm.includeAppendSaves) && Objects.equals(this.includeNoValueFields, operationSubmitFormActionSubmitForm.includeNoValueFields) && Objects.equals(this.submitCoordinates, operationSubmitFormActionSubmitForm.submitCoordinates) && Objects.equals(this.submitPDF, operationSubmitFormActionSubmitForm.submitPDF) && Objects.equals(this.url, operationSubmitFormActionSubmitForm.url) && Objects.equals(this.xfdf, operationSubmitFormActionSubmitForm.xfdf);
    }

    public int hashCode() {
        return Objects.hash(this.canonicalFormat, this.embedForm, this.exclude, this.excludeFDFSourceOrTargetFile, this.excludeNonUserAnnotations, this.exportFormat, this.field, this.getMethod, this.includeAnnotations, this.includeAppendSaves, this.includeNoValueFields, this.submitCoordinates, this.submitPDF, this.url, this.xfdf);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OperationSubmitFormActionSubmitForm {\n");
        sb.append("    canonicalFormat: ").append(this.toIndentedString(this.canonicalFormat)).append("\n");
        sb.append("    embedForm: ").append(this.toIndentedString(this.embedForm)).append("\n");
        sb.append("    exclude: ").append(this.toIndentedString(this.exclude)).append("\n");
        sb.append("    excludeFDFSourceOrTargetFile: ").append(this.toIndentedString(this.excludeFDFSourceOrTargetFile)).append("\n");
        sb.append("    excludeNonUserAnnotations: ").append(this.toIndentedString(this.excludeNonUserAnnotations)).append("\n");
        sb.append("    exportFormat: ").append(this.toIndentedString(this.exportFormat)).append("\n");
        sb.append("    field: ").append(this.toIndentedString(this.field)).append("\n");
        sb.append("    getMethod: ").append(this.toIndentedString(this.getMethod)).append("\n");
        sb.append("    includeAnnotations: ").append(this.toIndentedString(this.includeAnnotations)).append("\n");
        sb.append("    includeAppendSaves: ").append(this.toIndentedString(this.includeAppendSaves)).append("\n");
        sb.append("    includeNoValueFields: ").append(this.toIndentedString(this.includeNoValueFields)).append("\n");
        sb.append("    submitCoordinates: ").append(this.toIndentedString(this.submitCoordinates)).append("\n");
        sb.append("    submitPDF: ").append(this.toIndentedString(this.submitPDF)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    xfdf: ").append(this.toIndentedString(this.xfdf)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

